/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub.component;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppingEvent;
import cz.cuni.amis.pogamut.base.component.stub.component.CheckEvent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;

public class ManualCheckComponent
implements IComponent {
    private static int counter = 0;
    private Token token;
    private Queue<CheckEvent> expect = new LinkedList<CheckEvent>();
    private IComponentBus bus;
    private LogCategory log;

    public ManualCheckComponent(IAgentLogger logger, IComponentBus bus) {
        this(logger, bus, new CheckEvent[0]);
    }

    public ManualCheckComponent(IAgentLogger logger, IComponentBus bus, CheckEvent ... events) {
        this.token = Tokens.get((String)("ManualCheckComponent" + counter++));
        this.log = logger.getCategory((IComponent)this);
        NullCheck.check((Object)this.log, (String)"log initialization");
        this.expect(events);
        this.bus = bus;
        this.bus.register((IComponent)this);
    }

    public void expect(CheckEvent ... events) {
        for (CheckEvent event : events) {
            this.expect(event);
        }
    }

    public void expect(CheckEvent event) {
        this.expect.add(event);
    }

    public int getExpectSize() {
        return this.expect.size();
    }

    public void manualNotify(IComponentEvent<?> event) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Got event: " + event);
        }
        if (this.expect.size() == 0) {
            throw new RuntimeException("No event expected, but " + event.getClass() + " from " + event.getSource() + " came.");
        }
        this.expect.poll().check(event);
    }

    public IToken getComponentId() {
        return this.token;
    }

    public Logger getLog() {
        return this.log;
    }

    public String toString() {
        return this.getComponentId().getToken();
    }

    public void checkExpectEmpty() {
        Assert.assertTrue((String)"should not expect any events", (this.getExpectSize() == 0 ? 1 : 0) != 0);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Does not expecting any new events.");
        }
    }

    public void manualStart() {
        this.bus.event((IComponentEvent)new StartingEvent((IComponent)this));
        this.bus.event((IComponentEvent)new StartedEvent((IComponent)this));
    }

    public void manualStartPaused() {
        this.bus.event((IComponentEvent)new StartingPausedEvent((IComponent)this));
        this.bus.event((IComponentEvent)new PausedEvent((IComponent)this));
    }

    public void manualPause() {
        this.bus.event((IComponentEvent)new PausingEvent((IComponent)this));
        this.bus.event((IComponentEvent)new PausedEvent((IComponent)this));
    }

    public void manualStop() {
        this.bus.event((IComponentEvent)new StoppingEvent((IComponent)this));
        this.bus.event((IComponentEvent)new StoppedEvent((IComponent)this));
    }

    public void manualResume() {
        this.bus.event((IComponentEvent)new ResumingEvent((IComponent)this));
        this.bus.event((IComponentEvent)new ResumedEvent((IComponent)this));
    }

    public void manualFatalError() {
        this.bus.event((IComponentEvent)new FatalErrorEvent((IComponent)this, "SIMULATED FAILURE!"));
    }

    public void manualReset() {
        this.bus.reset();
    }
}

