/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.jmx;

import cz.cuni.amis.pogamut.base.utils.exception.PogamutJMXNameException;
import cz.cuni.amis.pogamut.base.utils.jmx.PogamutJMX;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategoriesMBean;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogPublisher;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class JMXLogCategories
implements ILogCategories,
JMXLogCategoriesMBean {
    protected ILogCategories logCategories;
    protected MBeanServer mBeanServer;
    protected ObjectName objectName = null;

    public JMXLogCategories(ILogCategories logCategories, MBeanServer mBeanServer, ObjectName parent) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, NullPointerException {
        this.logCategories = logCategories;
        this.mBeanServer = mBeanServer;
        this.objectName = ObjectName.getInstance(JMXLogCategories.getJMXLogCategoriesName(parent));
        mBeanServer.registerMBean(this, this.objectName);
        for (LogCategory category : this.getCategories().values()) {
            category.addHandler(this.newJMXLogPublisher(category.getName()));
        }
    }

    @Override
    public synchronized LogCategory getCategory(String name) {
        if (this.hasCategory(name)) {
            return this.logCategories.getCategory(name);
        }
        LogCategory newCategory = this.logCategories.getCategory(name);
        newCategory.addHandler(this.newJMXLogPublisher(name));
        return newCategory;
    }

    private JMXLogPublisher newJMXLogPublisher(String name) {
        try {
            ObjectName categoryObjName = ObjectName.getInstance(this.getJMXLogCategoryName(name));
            JMXLogPublisher logPublisher = new JMXLogPublisher(categoryObjName, name);
            this.mBeanServer.registerMBean(logPublisher, categoryObjName);
            return logPublisher;
        }
        catch (Exception e) {
            throw new PogamutException("Can't register JMXLogPublisher with name " + JMXLogCategories.getJMXLogCategoryName(this.objectName, name) + ".", (Throwable)e, (Object)this);
        }
    }

    @Override
    public Map<String, LogCategory> getCategories() {
        return this.logCategories.getCategories();
    }

    @Override
    public String[] getCategoryNames() {
        return this.logCategories.getCategoryNames();
    }

    @Override
    public String[] getCategoryNamesSorted() {
        return this.logCategories.getCategoryNamesSorted();
    }

    @Override
    public boolean hasCategory(String name) {
        return this.logCategories.hasCategory(name);
    }

    @Override
    public void setLevel(Level newLevel) {
        this.logCategories.setLevel(newLevel);
    }

    @Override
    public void addLogCategory(String name, LogCategory category) {
        this.logCategories.addLogCategory(name, category);
    }

    @Override
    public ObjectName getJMXLogCategoryName(String categoryName) throws PogamutJMXNameException {
        return JMXLogCategories.getJMXLogCategoryName(this.objectName, categoryName);
    }

    public static ObjectName getJMXLogCategoryName(ObjectName parent, String categoryName) throws PogamutJMXNameException {
        return PogamutJMX.getObjectName(parent, categoryName);
    }

    @Override
    public ObjectName getJMXLogCategoriesName() {
        return this.objectName;
    }

    public static ObjectName getJMXLogCategoriesName(ObjectName parent) throws PogamutJMXNameException {
        return PogamutJMX.getObjectName(parent, "logcat");
    }
}

