/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ILocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.worldview.events.BatchBeginEventStub;
import cz.cuni.amis.pogamut.multi.worldview.events.BatchEndEventStub;
import cz.cuni.amis.pogamut.multi.worldview.objects.CheckInstances;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObjectMessage;
import cz.cuni.amis.pogamut.multi.worldview.stub.BatchAwareLocalWVStub;
import cz.cuni.amis.pogamut.multi.worldview.stub.BatchAwareSharedWVStub;
import cz.cuni.amis.utils.StopWatch;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.junit.Test;

public class Test06_BatchAwareWorldView_2Agents_LotsTimeKeys {
    private static final long GLOBAL_TIMEOUT_IN_MINUTES = 30L;
    public static FileHandler fh;
    public static Logger global;
    public static List<IAgentLogger> agentLogs;
    public static ISharedWorldView sharedWV;
    static boolean failure;
    static CountDownLatch latch;
    static CountDownLatch latch2;

    public static void setLogLevel(Level level) {
        global.setLevel(level);
        for (IAgentLogger log : agentLogs) {
            log.setLevel(level);
        }
    }

    public static void initSWV() {
        try {
            fh = new FileHandler("./log01");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleFormatter f = new SimpleFormatter();
        fh.setFormatter(f);
        agentLogs = new LinkedList<IAgentLogger>();
        global = Logger.getLogger("Global");
        global.setLevel(Level.FINER);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINER);
        global.addHandler(consoleHandler);
        global.addHandler(fh);
        sharedWV = new BatchAwareSharedWVStub(global);
    }

    @Test(timeout=600000L)
    public void simpleTest() {
        Test06_BatchAwareWorldView_2Agents_LotsTimeKeys.initSWV();
        int events = 50;
        int runs = 10000;
        long sleepTime = 10L;
        long runnerSleepTime = 15L;
        Handler hndlr = new Handler();
        LinkedList<LogicRunner> thrds = new LinkedList<LogicRunner>();
        int agents = 2;
        latch = new CountDownLatch(agents + 1);
        TeamId tId = new TeamId("RED");
        EventGeneratorHandler eventHandler = new EventGeneratorHandler(events, 0L, sleepTime, hndlr);
        StopWatch watch = new StopWatch();
        for (int i = 0; i < agents; ++i) {
            TeamedAgentId teamedAgentId = new TeamedAgentId("Agent[" + i + "]");
            teamedAgentId.setTeamId(tId);
            LogicRunner r = new LogicRunner((ITeamedAgentId)teamedAgentId, runs, events, runnerSleepTime, hndlr);
            eventHandler.addWorldView((ILocalWorldView)r.wv);
            thrds.add(r);
            r.startWV();
        }
        Test06_BatchAwareWorldView_2Agents_LotsTimeKeys.setLogLevel(Level.INFO);
        for (Thread thread : thrds) {
            thread.start();
        }
        eventHandler.start();
        try {
            latch.await(30L, TimeUnit.MINUTES);
            if (latch.getCount() > 0L || failure) {
                failure = true;
                throw new RuntimeException("FAILURE!!!");
            }
        }
        catch (InterruptedException e) {
            failure = true;
            throw new RuntimeException(e);
        }
        System.out.println("Test took: " + watch.stopStr());
        thrds = null;
        eventHandler = null;
        sharedWV = null;
        try {
            CheckInstances.waitGCTotal();
        }
        catch (Exception e) {
            System.out.println("WARNING : ");
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void totalCountDown2() {
        while (latch2.getCount() > 0L) {
            latch2.countDown();
        }
    }

    public static void totalCountDown() {
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
    }

    static {
        failure = false;
    }

    public static class EventGeneratorHandler
    extends Thread {
        Map<TeamedAgentId, ILocalWorldView> localWorldViews;
        int eventsPerCycle;
        long currentTime;
        Handler handler;
        long sleepTime;

        public EventGeneratorHandler(int eventsPerCycle, long initTime, long sleepTime, Handler handlerInstance) {
            this.eventsPerCycle = eventsPerCycle;
            this.currentTime = initTime;
            this.handler = handlerInstance;
            this.sleepTime = sleepTime;
            this.localWorldViews = new HashMap<TeamedAgentId, ILocalWorldView>();
        }

        public void addWorldView(ILocalWorldView wv) {
            this.localWorldViews.put((TeamedAgentId)wv.getAgentId(), wv);
        }

        @Override
        public void run() {
            try {
                while (!this.handler.allFinished()) {
                    if (failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    LinkedList<EventGenerator> thrds = new LinkedList<EventGenerator>();
                    for (TeamedAgentId teamedAgentId : this.localWorldViews.keySet()) {
                        if (this.handler.cyclesToRun((IAgentId)teamedAgentId) < 0) continue;
                        thrds.add(new EventGenerator(this.eventsPerCycle, this.currentTime, this.localWorldViews.get(teamedAgentId)));
                    }
                    latch2 = new CountDownLatch(thrds.size());
                    for (Thread thread : thrds) {
                        thread.start();
                    }
                    latch2.await(30L, TimeUnit.MINUTES);
                    if (latch2.getCount() > 0L || failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    ++this.currentTime;
                    EventGeneratorHandler.sleep(this.sleepTime);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test06_BatchAwareWorldView_2Agents_LotsTimeKeys.totalCountDown();
                return;
            }
            latch.countDown();
        }
    }

    public static class LogicRunner
    extends Thread {
        protected BatchAwareLocalWorldView wv;
        protected ITeamedAgentId id;
        int runs;
        int objects;
        long sleepTime;
        Handler handler;
        ComponentStub starter;

        public LogicRunner(ITeamedAgentId id, int runs, int objects, long sleepTime, Handler handler) {
            AgentLogger log = new AgentLogger((IAgentId)id);
            agentLogs.add((IAgentLogger)log);
            log.setLevel(Level.ALL);
            log.addDefaultConsoleHandler();
            log.addDefaultHandler((java.util.logging.Handler)fh);
            LifecycleBus bus = new LifecycleBus((IAgentLogger)log);
            this.starter = new ComponentStub((IAgentLogger)log, (IComponentBus)bus);
            try {
                this.wv = new BatchAwareLocalWVStub(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)this.starter), (ILifecycleBus)bus, (IAgentLogger)log, sharedWV, id);
            }
            catch (Exception e) {
                failure = true;
                e.printStackTrace();
            }
            this.wv.setInitialTime(TimeKey.get((long)0L));
            this.id = id;
            this.runs = runs;
            this.objects = objects;
            this.sleepTime = sleepTime;
            this.handler = handler;
            handler.addNew((IAgentId)id, runs);
        }

        public void startWV() {
            this.starter.getController().manualStart("Test");
        }

        public void setSleepTime(long newSleepTime) {
            this.sleepTime = newSleepTime;
        }

        @Override
        public void run() {
            try {
                System.out.println(this.id + " : Logic Runner run()");
                for (int r = 0; r <= this.runs; ++r) {
                    if (failure) {
                        throw new RuntimeException("FAILURE DETECTED!");
                    }
                    this.wv.lock();
                    System.out.println(this.id + "Runner run [" + r + "] remaining : time " + this.wv.getCurrentTimeKey().getTime() + ", remaining runs " + this.handler.cyclesToRun((IAgentId)this.id));
                    for (int i = 0; i < this.objects; ++i) {
                        long t = this.wv.getCurrentTimeKey().getTime();
                        TestCompositeObject obj = (TestCompositeObject)this.wv.get(WorldObjectId.get((String)("TestObject[" + i + "]")));
                        if (obj == null) {
                            global.severe(this.id + " : NULL");
                            throw new RuntimeException("Object is null.");
                        }
                        if (obj.getLocalLong() != (long)i + t) {
                            global.severe(obj.getId() + " : " + obj.getLocalString());
                            global.severe("LocalLong fail on  object " + i + " in run " + r + " ; on WV time " + t);
                            this.handler.setEnd((IAgentId)this.id);
                            throw new RuntimeException("LocalLong fail on  object " + i + " in run " + r + " ; on WV time " + t);
                        }
                        if (!obj.getLocalString().equals("LS:" + this.id.toString() + "[" + i + "]" + "(" + t + ")")) {
                            throw new RuntimeException("LocalString fail");
                        }
                        if (obj.getSharedLong() != (long)(i + 1000) + t) {
                            global.severe(this.id + " : " + obj.getSharedLong() + " instead of " + ((long)(i + 1000) + t));
                            throw new RuntimeException("SharedLong fail");
                        }
                        if (!obj.getSharedString().equals("ShS:" + this.id.getTeamId().toString() + "[" + i + "]" + "(" + t + ")")) {
                            throw new RuntimeException("SharedString fail : " + obj.getSharedString());
                        }
                        if (obj.getStaticLong() != (long)i) {
                            throw new RuntimeException("StaticLong fail");
                        }
                        if (obj.getStaticString().equals("StaticString[" + i + "]")) continue;
                        throw new RuntimeException("StaticString fail");
                    }
                    LogicRunner.sleep(this.sleepTime);
                    this.wv.unlock();
                    this.handler.decrease((IAgentId)this.id);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test06_BatchAwareWorldView_2Agents_LotsTimeKeys.totalCountDown();
                return;
            }
            latch.countDown();
        }
    }

    public static class EventGenerator
    extends Thread {
        int events;
        long time;
        ILocalWorldView localWV;
        TeamedAgentId agentId;

        public EventGenerator(int events, long time, ILocalWorldView localWV) {
            this.events = events;
            this.time = time;
            this.localWV = localWV;
            this.agentId = (TeamedAgentId)localWV.getAgentId();
        }

        protected void generateEvents() {
            System.out.println(this.agentId + " : generating Events [Time:" + this.time + "]");
            this.localWV.notify((IWorldChangeEvent)new BatchBeginEventStub(this.time));
            for (int i = 0; i < this.events; ++i) {
                WorldObjectId id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                TestCompositeObjectMessage obj = new TestCompositeObjectMessage(id, this.time, "LS:" + this.agentId.toString() + "[" + i + "]" + "(" + this.time + ")", (long)i + this.time, "ShS:" + this.agentId.getTeamId().toString() + "[" + i + "]" + "(" + this.time + ")", (long)(i + 1000) + this.time, "StaticString[" + i + "]", Long.valueOf(i));
                this.localWV.notify((IWorldChangeEvent)obj.createUpdateEvent(this.time, this.agentId.getTeamId()));
            }
            this.localWV.notify((IWorldChangeEvent)new BatchEndEventStub(this.time));
            System.out.println(this.agentId + ": generating end");
        }

        @Override
        public void run() {
            try {
                this.generateEvents();
            }
            catch (Exception e) {
                e.printStackTrace();
                failure = true;
                Test06_BatchAwareWorldView_2Agents_LotsTimeKeys.totalCountDown2();
                return;
            }
            latch2.countDown();
        }
    }

    public static class Handler {
        Map<IAgentId, Integer> cycles = new HashMap<IAgentId, Integer>();

        public void addNew(IAgentId id, int cycles) {
            this.cycles.put(id, cycles);
        }

        public boolean allFinished() {
            for (Integer i : this.cycles.values()) {
                if (i < 0) continue;
                return false;
            }
            return true;
        }

        public synchronized void setEnd(IAgentId id) {
            this.cycles.put(id, -1);
        }

        public synchronized void decrease(IAgentId id) {
            int n = this.cycles.get(id);
            this.cycles.put(id, --n);
        }

        public int cyclesToRun(IAgentId id) {
            return this.cycles.get(id);
        }
    }
}

