/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.jmx.proxy;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.jmx.DynamicMBeanToFolderAdapter;
import cz.cuni.amis.introspection.jmx.DynamicProxy;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.jmx.proxy.AgentIdJMXProxy;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.jmx.FolderToIJMXEnabledAdapter;
import cz.cuni.amis.pogamut.base.utils.jmx.flag.FlagJMXProxy;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.AgentLoggerJMXProxy;
import cz.cuni.amis.utils.Lazy;
import cz.cuni.amis.utils.exception.PogamutJMXException;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class AgentJMXProxy
implements IAgent {
    FlagJMXProxy<IAgentState> agentFlag = null;
    DynamicProxy proxy = null;
    private Lazy<IAgentLogger> agentLogger = new Lazy<IAgentLogger>(){

        protected IAgentLogger create() {
            return new AgentLoggerJMXProxy(new AgentId(), AgentJMXProxy.this.mbsc, AgentJMXProxy.this.agentName);
        }
    };
    private Lazy<Folder> folder = new Lazy<Folder>(){

        protected Folder create() {
            try {
                ObjectName introspectionRoot = FolderToIJMXEnabledAdapter.getFolderObjectNameForParent(AgentJMXProxy.this.agentName, "root");
                DynamicProxy proxy = new DynamicProxy(introspectionRoot, AgentJMXProxy.this.mbsc);
                return new DynamicMBeanToFolderAdapter(proxy);
            }
            catch (MalformedObjectNameException ex) {
                throw new RuntimeException(ex);
            }
        }
    };
    private MBeanServerConnection mbsc = null;
    private ObjectName agentName = null;
    private AgentIdJMXProxy agentId;

    public AgentJMXProxy(String agentJmxAddress) {
        String[] strs = agentJmxAddress.split("\\|");
        String jmxService = strs[0];
        String objectName = strs[1];
        try {
            JMXServiceURL url = new JMXServiceURL(jmxService);
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            this.mbsc = jmxc.getMBeanServerConnection();
            this.agentName = ObjectName.getInstance(objectName);
            this.proxy = new DynamicProxy(this.agentName, this.mbsc);
            this.agentFlag = new FlagJMXProxy(this.agentName, this.mbsc, "agent_state_flag");
            this.agentId = new AgentIdJMXProxy(this);
        }
        catch (Exception e) {
            throw new PogamutJMXException("Can't create AgentJMXProxy.", (Throwable)e, (Object)this);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public ObjectName getObjectName() {
        return this.agentName;
    }

    @Override
    public IAgentLogger getLogger() {
        return (IAgentLogger)this.agentLogger.get();
    }

    public Logger getLog() {
        return this.getLogger().getCategory(this.getComponentId().getToken());
    }

    @Override
    public ImmutableFlag<IAgentState> getState() {
        return this.agentFlag.getImmutable();
    }

    protected Object callNoException(String actionName) {
        try {
            return this.call(actionName);
        }
        catch (AgentException ex) {
            throw new RuntimeException((Throwable)((Object)ex));
        }
    }

    protected Object callNoException(String actionName, Object[] params, String[] sig) {
        try {
            return this.proxy.invoke(actionName, params, sig);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object call(String actionName) throws AgentException {
        try {
            return this.proxy.invoke(actionName, null, null);
        }
        catch (Exception ex) {
            throw new AgentException("JMX communication exception. Error executing method :" + actionName + ".", ex, (Object)this);
        }
    }

    protected Object getAttributeNoException(String atr) {
        try {
            return this.proxy.getAttribute(atr);
        }
        catch (Exception ex) {
            throw new RuntimeException("Atribute retrieval error.", ex);
        }
    }

    @Override
    public void start() throws AgentException {
        this.call("start");
    }

    @Override
    public void startPaused() throws ComponentCantStartException {
        this.call("startPaused");
    }

    @Override
    public void pause() throws AgentException {
        this.call("pause");
    }

    @Override
    public void resume() throws AgentException {
        this.call("resume");
    }

    @Override
    public void stop() {
        this.callNoException("stop");
    }

    @Override
    public void kill() {
        this.callNoException("kill");
    }

    @Override
    public IAgentId getComponentId() {
        return this.agentId;
    }

    @Override
    public String getName() {
        return (String)this.getComponentId().getName().getFlag();
    }

    @Override
    public Folder getIntrospection() {
        return (Folder)this.folder.getVal();
    }

    @Override
    public IComponentBus getEventBus() {
        throw new UnsupportedOperationException("not supported");
    }
}

