package cz.cuni.amis.pogamut.base.utils;

import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogClient;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogManager;

/**
 * The key is returned via {@link PogamutProperty#toString()} method.
 * 
 * @author Jimmy
 */
public enum PogamutProperty {
	

	/**
	 * Default logging level for the bot, set inside {@link AgentLogger#AgentLogger(cz.cuni.amis.pogamut.base.agent.IAgentId)} constructor.
	 */
	POGAMUT_LOGGER_LEVEL_DEFAULT("pogamut.logger.level.default"),

	/**
	 * Domain used for MBeans registered from the Pogamut.
	 */
	POGAMUT_JMX_DOMAIN("pogamut.jmx.domain"), 
	
	/**
	 * Subdomain used for agent MBean registered from the Pogamut.
	 */
	POGAMUT_JMX_SUBDOMAIN("pogamut.jmx.subdomain"),
	
	/**
	 * Port of the RMI registry.
	 */
	POGAMUT_JMX_SERVER_RMI_PORT("pogamut.jmx.server.rmi.port"),

	/**
	 * address where the JMX server will run this should be the global IP since
	 * other tools might want to use this address if blank than some IP will be choosen
	 * automatically.
	 */
	POGAMUT_JMX_SERVER_ADDRESS("pogamut.jmx.server.address"),
	
	/**
	 * Changes the log level of the {@link NetworkLogManager} singleton and {@link NetworkLogClient} instances.
	 */
	POGAMUT_NETWORK_LOG_MANAGER_AND_CLIENT_LEVEL("pogamut.network.log.level");

	private String key;

	private PogamutProperty(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}
	
	public String toString() {
		return key;
	}
	
}
