/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.network;

import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogManager;
import cz.cuni.amis.pogamut.base.utils.logging.network.CheckNetworkLogClient;
import cz.cuni.amis.pogamut.base.utils.logging.network.NetworkLoggingAgent;
import cz.cuni.amis.pogamut.base.utils.logging.network.NetworkLoggingTest;
import org.junit.Test;

public class Test02_NetworkLogging_1Agent_2Clients
extends NetworkLoggingTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        try {
            double logicFrequency = 5.0;
            int logsPerCycle = 1000;
            int lifeTimeSeconds = 2;
            int logicCycles = (int)Math.ceil(logicFrequency * (double)lifeTimeSeconds);
            int totalLogsOfOneCategory = logsPerCycle * logicCycles;
            NetworkLoggingAgent agent1 = this.createNewAgent(logicFrequency, logsPerCycle, logicCycles);
            agent1.start();
            try {
                CheckNetworkLogClient logClient1 = new CheckNetworkLogClient("LogClient1-" + agent1.getName(), "localhost", NetworkLogManager.getNetworkLogManager().getLoggerPort(), agent1.getComponentId().getToken());
                CheckNetworkLogClient logClient2 = new CheckNetworkLogClient("LogClient2-" + agent1.getName(), "localhost", NetworkLogManager.getNetworkLogManager().getLoggerPort(), agent1.getComponentId().getToken());
                logClient1.start();
                try {
                    try {
                        logClient2.start();
                        System.out.println("[INFO]  Dropping agent logic latch, starting to send logs...");
                        agent1.getLogicLatch().countDown();
                        agent1.awaitState(IAgentStateDown.class);
                        logClient1.getRunning().waitFor(1000L, (Object[])new Boolean[]{false});
                        logClient1.getThroughput().check();
                        logClient2.getRunning().waitFor(1000L, (Object[])new Boolean[]{false});
                        logClient2.getThroughput().check();
                        this.checkAgent(agent1);
                        this.checkLogClient(logClient1, totalLogsOfOneCategory);
                        this.checkLogClient(logClient2, totalLogsOfOneCategory);
                    }
                    finally {
                        if (((Boolean)logClient2.getRunning().getFlag()).booleanValue()) {
                            logClient2.stop();
                        }
                    }
                }
                finally {
                    if (((Boolean)logClient1.getRunning().getFlag()).booleanValue()) {
                        logClient1.stop();
                    }
                }
            }
            catch (Throwable throwable) {
                if (agent1.notInState(new Class[]{IAgentStateDown.class})) {
                    agent1.kill();
                }
                throw throwable;
            }
            if (agent1.notInState(new Class[]{IAgentStateDown.class})) {
                agent1.kill();
            }
        }
        finally {
            Pogamut.getPlatform().close();
        }
        System.out.println("---/// TEST OK ///---");
    }
}

