/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.network;

import cz.cuni.amis.pogamut.base.agent.jmx.proxy.AgentJMXProxy;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.network.CheckNetworkLogClient;
import cz.cuni.amis.pogamut.base.utils.logging.network.JMXNetworkLoggingAgent;
import cz.cuni.amis.pogamut.base.utils.logging.network.JMXNetworkLoggingTest;
import org.junit.Test;

public class Test08_5x_JMXEnabledNetworkLoggingFull
extends JMXNetworkLoggingTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        try {
            double logicFrequency = 5.0;
            int logsPerCycle = 2000;
            int lifeTimeSeconds = 2;
            int logicCycles = (int)Math.ceil(logicFrequency * (double)lifeTimeSeconds);
            int totalLogsOfOneCategory = logsPerCycle * logicCycles;
            JMXNetworkLoggingAgent agent = this.createNewAgentJMX(logicFrequency, logsPerCycle, logicCycles);
            AgentJMXProxy agentProxy = null;
            for (int i = 0; i < 5; ++i) {
                System.out.println("[INFO] Test " + (i + 1) + " / 5");
                System.out.println("[INFO] Starting agent... ");
                agent.start();
                if (i == 0) {
                    System.out.println("[INFO] Enabling agent JMX... ");
                    String agentAddress = agent.getJMX().enableJMX();
                    System.out.println("[INFO] Creating AgentJMXProxy... ");
                    agentProxy = new AgentJMXProxy(agentAddress);
                }
                System.out.println("[INFO] Enabling network logging via JMX...");
                agentProxy.getLogger().addDefaultNetworkHandler();
                System.out.println("[INFO] Obtaining host:port address of the network logger...");
                String host = agentProxy.getLogger().getNetworkLoggerHost();
                Integer port = agentProxy.getLogger().getNetworkLoggerPort();
                if (host == null) {
                    System.out.println("[ERROR] HOST is NULL!! agentProxy.getLogger().getNetworkLoggerHost() failed!");
                    throw new RuntimeException("[SEVERE] HOST is NULL!! agentProxy.getLogger().getNetworkLoggerHost() failed!");
                }
                if (port == null) {
                    System.out.println("[ERROR] PORT is NULL!! agentProxy.getLogger().getNetworkLoggerPort() failed!");
                    throw new RuntimeException("[ERROR] PORT is NULL!! agentProxy.getLogger().getNetworkLoggerPort() failed!");
                }
                if (port <= 0) {
                    System.out.println("[ERROR] PORT <= 0!! agentProxy.getLogger().getNetworkLoggerPort() failed!");
                    throw new RuntimeException("[ERROR] PORT <= 0!! agentProxy.getLogger().getNetworkLoggerPort() failed!");
                }
                System.out.println("[INFO] Network logging is running at " + host + ":" + port + " ...");
                try {
                    System.out.println("[INFO] Creating NetworkLogClient...");
                    CheckNetworkLogClient logClient1 = new CheckNetworkLogClient("LogClient1-" + agent.getName(), host, port, agent.getComponentId().getToken());
                    System.out.println("[INFO] starting NetworkLogClient...");
                    logClient1.start();
                    try {
                        System.out.println("[INFO]  Dropping agent logic latch, starting to send logs...");
                        agent.getLogicLatch().countDown();
                        agent.awaitState(IAgentStateDown.class);
                        logClient1.getRunning().waitFor(1000L, (Object[])new Boolean[]{false});
                        logClient1.getThroughput().check();
                        this.checkAgent(agent);
                        this.checkLogClient(logClient1, totalLogsOfOneCategory);
                    }
                    finally {
                        if (((Boolean)logClient1.getRunning().getFlag()).booleanValue()) {
                            logClient1.stop();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (agent.notInState(new Class[]{IAgentStateDown.class})) {
                        agent.kill();
                    }
                    throw throwable;
                }
                if (!agent.notInState(new Class[]{IAgentStateDown.class})) continue;
                agent.kill();
            }
        }
        finally {
            Pogamut.getPlatform().close();
        }
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void testAgain1() {
        this.test();
    }

    @Test
    public void testAgain2() {
        this.test();
    }

    @Test
    public void testAgain3() {
        this.test();
    }
}

