/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.leaktest;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.params.impl.AgentParameters;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLeakTest {
    public abstract IAgentFactory getFactory();

    public abstract ImmutableFlag<Integer> getInstances();

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException((Throwable)e, (Object)this);
        }
    }

    protected int getNumAgentsToInstantiate() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        int i;
        IAgentFactory factory = this.getFactory();
        StopWatch watch = new StopWatch();
        for (i = 0; i < this.getNumAgentsToInstantiate(); ++i) {
            IAgent agent = factory.newAgent((IAgentParameters)new AgentParameters().setAgentId((IAgentId)new AgentId("TestAgent1" + (i + 1))));
            System.out.println("/In test/ Agent(" + (i + 1) + "/" + this.getNumAgentsToInstantiate() + ") started.");
            agent.start();
            this.sleep(10L);
            agent.pause();
            System.out.println("/In test/ " + this.getClass().getSimpleName() + "'s instances count = " + this.getInstances().getFlag());
            Assert.assertTrue((String)(this.getClass().getSimpleName() + "'s instances must be > 0"), ((Integer)this.getInstances().getFlag() > 0 ? 1 : 0) != 0);
            this.sleep(10L);
            agent.resume();
            this.sleep(10L);
            agent.stop();
            System.out.println("/In test/ Agent stopped.");
            this.sleep(10L);
        }
        System.out.println("Agents finished in " + watch.stopStr() + ".");
        factory = null;
        try {
            for (i = 0; i < 30; ++i) {
                System.gc();
                Integer value = (Integer)this.getInstances().waitFor(1000L, (Object[])new Integer[]{0});
                if (value != null && value == 0) {
                    System.out.println("All instances of " + this.getClass().getSimpleName() + " has been gc()ed, " + this.getClass().getSimpleName() + "'s instances = " + this.getInstances().getFlag() + ".");
                    System.out.println("---/// TEST OK ///---");
                    return;
                }
                System.out.println("/" + (i + 1) + " sec" + (i != 0 ? "s" : "") + "/ " + this.getClass().getSimpleName() + "'s instances count = " + this.getInstances().getFlag());
            }
        }
        finally {
            Pogamut.getPlatform().close();
        }
        String str = "Not all " + this.getClass().getSimpleName() + " instances were gc()ed in 30secs after the test end, " + this.getClass().getSimpleName() + "'s instances = " + this.getInstances().getFlag() + ".";
        System.out.println(str);
        Assert.fail((String)str);
    }
}

