/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner;

import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentRunner;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgent1Module;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentParams;
import cz.cuni.amis.pogamut.base.agent.utils.runner.test.TestAgentRunner;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.tests.BaseTest;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class Test09_AgentRunner_Main_5AgentsWithParams
extends BaseTest {
    protected IAgentRunner initAgentRunner() {
        return new TestAgentRunner((IAgentFactory)new GuiceAgentFactory((GuiceAgentModule)new TestAgent1Module())){

            protected void postStartedHook(List<AbstractAgent> agents) {
                System.out.println("All agents have been started, stopping them...");
                for (AbstractAgent agent : agents) {
                    agent.stop();
                }
            }
        }.setMain(true);
    }

    @Test
    public void test_start5AgentsWithDifferentParams() {
        int i;
        IAgentRunner runner = this.initAgentRunner();
        int NUM_AGENTS = 5;
        System.out.println("Starting " + NUM_AGENTS + " agents with different parameters...");
        TestAgentParams[] params = new TestAgentParams[NUM_AGENTS];
        for (int i2 = 0; i2 < NUM_AGENTS; ++i2) {
            params[i2] = new TestAgentParams(i2);
        }
        List agents = runner.startAgents((IAgentParameters[])params);
        System.out.println("Checking agents classes...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)(agents.get(i) instanceof TestAgent1));
        }
        System.out.println("OK");
        System.out.println("Check agents' parameters...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((((TestAgent1)((Object)agents.get(i))).getParam() == i ? 1 : 0) != 0);
        }
        System.out.println("OK");
        System.out.println("Checking agents stopped...");
        for (i = 0; i < NUM_AGENTS; ++i) {
            Assert.assertTrue((boolean)((IAgentState)((AbstractAgent)agents.get(i)).getState().getFlag()).isState(new Class[]{IAgentStateDown.class}));
        }
        System.out.println("OK");
        System.out.println("---/// TEST OK ///---");
        System.out.println("");
        System.out.println("IF THE TEST DOES NOT TERMINATE ITSELF AFTER THIS POINT - IT MEANS THAT 'main' FEATURE OF THE IAgentRunner IS BROKEN!!!");
    }

    public static void main(String[] args) {
        Test09_AgentRunner_Main_5AgentsWithParams test = new Test09_AgentRunner_Main_5AgentsWithParams();
        test.test_start5AgentsWithDifferentParams();
    }
}

