/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentIdClashException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.junit.Test;

public class Test03_ComponentBus
extends BaseTest {
    @Test
    public void test() {
        AgentId agentId = new AgentId("Test03_ComponentBus");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        IComponent cmp1 = new IComponent((IAgentLogger)logger){
            final /* synthetic */ IAgentLogger val$logger;
            {
                this.val$logger = iAgentLogger;
            }

            public IToken getComponentId() {
                return Tokens.get((String)"IdClashToken");
            }

            public Logger getLog() {
                return this.val$logger.getCategory("CMP1");
            }
        };
        IComponent cmp2 = new IComponent((IAgentLogger)logger){
            final /* synthetic */ IAgentLogger val$logger;
            {
                this.val$logger = iAgentLogger;
            }

            public IToken getComponentId() {
                return Tokens.get((String)"IdClashToken");
            }

            public Logger getLog() {
                return this.val$logger.getCategory("CMP2");
            }
        };
        bus.register(cmp1);
        boolean exception = false;
        try {
            bus.register(cmp1);
        }
        catch (ComponentIdClashException e) {
            exception = true;
        }
        Assert.assertTrue((String)"registering the same component twice should not result in an exception", (!exception ? 1 : 0) != 0);
        exception = false;
        Assert.assertTrue((String)("retrieved component under id " + cmp1.getComponentId().getToken() + " is not the same as " + cmp1), (bus.getComponent(cmp1.getComponentId()) == cmp1 ? 1 : 0) != 0);
        try {
            bus.register(cmp2);
        }
        catch (ComponentIdClashException e) {
            exception = true;
        }
        Assert.assertTrue((String)"registering two components under the same id should throw an exception", (boolean)exception);
        Assert.assertTrue((String)("retrieved component under id " + cmp1.getComponentId().getToken() + " is not the same as " + cmp1), (bus.getComponent(cmp1.getComponentId()) == cmp1 ? 1 : 0) != 0);
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test03_ComponentBus test = new Test03_ComponentBus();
        test.test();
    }
}

