/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenSharedWorldView;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.pogamut.multi.worldview.objects.CheckInstances;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObjectMessage;
import cz.cuni.amis.pogamut.multi.worldview.stub.EventDrivenLocalWorldViewStub;
import cz.cuni.amis.pogamut.multi.worldview.stub.EventDrivenSharedWorldViewStub;
import cz.cuni.amis.tests.BaseTest;
import java.util.Map;
import java.util.Random;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class Test00_SingleMultiWVTest
extends BaseTest {
    public EventDrivenLocalWorldView localWV;
    public EventDrivenSharedWorldView sharedWV;
    public TeamedAgentId agentId;
    public static Logger log;
    public static AgentLogger agentLogger;
    public static Random rand;

    public void setUp() {
        this.agentId = new TeamedAgentId("Agent01");
        this.agentId.setTeamId(new TeamId("teamRED"));
        agentLogger = new AgentLogger((IAgentId)this.agentId);
        LifecycleBus bus = new LifecycleBus((IAgentLogger)agentLogger);
        Logger sharedLogger = Logger.getLogger("SharedLogger");
        sharedLogger.addHandler(new ConsoleHandler());
        sharedLogger.setLevel(Level.INFO);
        agentLogger.setLevel(Level.INFO);
        agentLogger.addDefaultConsoleHandler();
        this.sharedWV = new EventDrivenSharedWorldViewStub(sharedLogger);
        ComponentStub starter = new ComponentStub((IAgentLogger)agentLogger, (IComponentBus)bus);
        this.localWV = new EventDrivenLocalWorldViewStub(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)starter), (ILifecycleBus)bus, (IAgentLogger)agentLogger, (ISharedWorldView)this.sharedWV, (ITeamedAgentId)this.agentId);
        starter.getController().manualStart("TEST");
        this.localWV.setCurrentTime(TimeKey.get((long)0L));
    }

    @Test(timeout=180000L)
    public void getAllTest() {
        this.setUp();
        int objects = 250;
        for (long t = 0L; t < 100L; ++t) {
            System.out.println("Time : " + t);
            this.localWV.lockTime(t);
            if (t >= 4L) {
                this.localWV.unlockTime(t - 4L);
            }
            for (int i = 0; i < objects; ++i) {
                WorldObjectId id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                TestCompositeObjectMessage message = new TestCompositeObjectMessage(id, t, "Local string [" + i + "," + t + "]", (long)i + t, "Shared string [" + i + "s," + t + "]", 200L + (long)i + 5L * t, "Static string " + i, (long)i * 100L);
                this.localWV.notify((IWorldChangeEvent)message.createUpdateEvent(t, this.agentId.getTeamId()));
            }
            this.localWV.setCurrentTime(TimeKey.get((long)t));
            Map map = this.localWV.getAll(TestCompositeObject.class);
            if (map.size() != objects) {
                Assert.fail((String)"MapSize fail");
            }
            for (int i = 0; i < objects; ++i) {
                WorldObjectId id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                TestCompositeObject obj = (TestCompositeObject)map.get(id);
                if (obj == null) {
                    log.severe(id + " : NULL");
                    Assert.fail((String)"Object is null.");
                }
                if (obj.getLocalLong() != (long)i + t) {
                    log.severe(id + " : " + obj.getLocalLong() + " instead of " + ((long)i + t));
                    Assert.fail((String)"LocalLong fail");
                }
                if (!obj.getLocalString().equals("Local string [" + i + "," + t + "]")) {
                    Assert.fail((String)"SharedString fail");
                }
                if (obj.getSharedLong() != (long)(200 + i) + 5L * t) {
                    log.severe(id + " : " + obj.getSharedLong() + " instead of " + ((long)(200 + i) + 5L * t));
                    Assert.fail((String)"SharedLong fail");
                }
                if (!obj.getSharedString().equals("Shared string [" + i + "s," + t + "]")) {
                    Assert.fail((String)("SharedString fail : " + obj.getSharedString()));
                }
                if (obj.getStaticLong() == (long)(i * 100)) continue;
                Assert.fail((String)"StaticLong fail");
            }
        }
        for (int dT = 0; dT < 4; ++dT) {
            this.localWV.unlockTime((long)(99 - dT));
        }
        this.localWV = null;
        this.sharedWV = null;
        this.agentId = null;
        CheckInstances.waitGCTotal();
    }

    @Test(timeout=180000L)
    public void shadowCopyTest() {
        this.setUp();
        agentLogger.setLevel(Level.FINER);
        int objects = 200;
        int logicCountdown = 2;
        int dT = 2;
        for (long t = 0L; t < 100L; ++t) {
            WorldObjectId id;
            int i;
            System.out.println("ShadowCopyTest : Time : " + t);
            this.localWV.lockTime(t);
            if (t >= 5L) {
                this.localWV.unlockTime(t - 5L);
            }
            for (i = 0; i < objects; ++i) {
                id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                TestCompositeObjectMessage message = new TestCompositeObjectMessage(id, t, "Local string [" + i + "," + t + "]", (long)i + t, "Shared string [" + i + "s," + t + "]", 200L + (long)i + 5L * t, "Static string " + i, (long)i * 100L);
                this.localWV.notify((IWorldChangeEvent)message.createUpdateEvent(t, this.agentId.getTeamId()));
            }
            if (logicCountdown == 0) {
                this.localWV.setCurrentTime(TimeKey.get((long)(t - (long)dT)));
                for (i = 0; i < objects; ++i) {
                    id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                    TestCompositeObject obj = (TestCompositeObject)this.localWV.get(id);
                    log.fine("Object " + id + " get() successful.");
                    if (obj.getSharedLong() != (long)(200 + i) + 5L * (t - (long)dT)) {
                        log.severe(id + " : " + obj.getSharedLong() + " instead of " + ((long)(200 + i) + 5L * (t - (long)dT)));
                        Assert.fail((String)"SharedLong fail");
                    }
                    if (obj.getLocalLong() != (long)i + t - (long)dT) {
                        log.severe(id + " : " + obj.getLocalLong() + " instead of " + ((long)i + t - (long)dT));
                        Assert.fail((String)"LocalLong fail");
                    }
                    if (!obj.getLocalString().equals("Local string [" + i + "," + (t - (long)dT) + "]")) {
                        Assert.fail((String)"SharedString fail");
                    }
                    if (!obj.getSharedString().equals("Shared string [" + i + "s," + (t - (long)dT) + "]")) {
                        Assert.fail((String)("SharedString fail : " + obj.getSharedString()));
                    }
                    if (obj.getStaticLong() == (long)(i * 100)) continue;
                    Assert.fail((String)"StaticLong fail");
                }
                dT = logicCountdown = rand.nextInt(3) + 1;
            }
            --logicCountdown;
        }
        for (dT = 0; dT < 5; ++dT) {
            this.localWV.unlockTime((long)(99 - dT));
        }
        this.localWV = null;
        this.sharedWV = null;
        this.agentId = null;
        CheckInstances.waitGCTotal();
    }

    @Test(timeout=180000L)
    public void simple1000Objects() {
        this.setUp();
        this.localWV.setCurrentTime(TimeKey.get((long)0L));
        for (long t = 0L; t < 50L; ++t) {
            WorldObjectId id;
            int i;
            this.localWV.lockTime(t);
            for (i = 0; i < 1000; ++i) {
                id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                TestCompositeObjectMessage message = new TestCompositeObjectMessage(id, t, "Local string [" + i + "," + t + "]", (long)i + t, "Shared string [" + i + "s," + t + "]", 200L + (long)i + 5L * t, "Static string " + i, (long)i * 100L);
                this.localWV.notify((IWorldChangeEvent)message.createUpdateEvent(t, this.agentId.getTeamId()));
            }
            this.localWV.setCurrentTime(TimeKey.get((long)t));
            for (i = 0; i < 1000; ++i) {
                id = WorldObjectId.get((String)("TestObject[" + i + "]"));
                TestCompositeObject obj = (TestCompositeObject)this.localWV.get(id);
                if (obj.getLocalLong() != (long)i + t) {
                    Assert.fail((String)"LocalLong fail");
                }
                if (!obj.getLocalString().equals("Local string [" + i + "," + t + "]")) {
                    Assert.fail((String)"SharedString fail");
                }
                if (obj.getSharedLong() != (long)(200 + i) + 5L * t) {
                    Assert.fail((String)"SharedLong fail");
                }
                if (!obj.getSharedString().equals("Shared string [" + i + "s," + t + "]")) {
                    Assert.fail((String)("SharedString fail : " + obj.getSharedString()));
                }
                if (obj.getStaticLong() == (long)(i * 100)) continue;
                Assert.fail((String)"StaticLong fail");
            }
            this.localWV.unlockTime(t);
            System.out.println("SimpleObjectTest : TimeKey " + t + " FINISHED!");
        }
        this.localWV = null;
        this.sharedWV = null;
        this.agentId = null;
        CheckInstances.waitGCTotal();
        System.out.println("---/// TEST OK ///---");
    }

    @After
    public void afterTest() {
        try {
            TimeKeyManager.get().unlockAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TimeKey.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        rand = new Random(System.currentTimeMillis());
        log = Logger.getLogger("GLOBAL");
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.FINER);
        log.setLevel(Level.FINER);
        log.addHandler(h);
    }
}

