/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview.stub;

import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestSharedObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestSharedObjectImpl;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class SharedObjectCreatorStub {
    private static Map<Class, ISharedObjectCreator> creatorMap = new HashMap<Class, ISharedObjectCreator>();

    public static ISharedWorldObject create(Collection<ISharedProperty> properties) {
        Class compClass = null;
        for (ISharedProperty p : properties) {
            if (compClass == null) {
                compClass = p.getCompositeClass();
                continue;
            }
            if (compClass.equals(p.getCompositeClass())) continue;
            throw new PogamutException("Composite classes don't match in SharedObjectCreatorStub.create()... c1 : " + compClass.getSimpleName() + "  !=" + " " + p.getCompositeClass().getSimpleName() + " .", (Object)p);
        }
        if (creatorMap.get(compClass) == null) {
            throw new PogamutException("Wrong CompositeObjectClass -- sharedObjectCreator nonexistent : " + compClass.getSimpleName(), (Object)compClass);
        }
        return creatorMap.get(compClass).create(properties);
    }

    static {
        creatorMap.put(TestCompositeObject.class, new TestSharedObjectCreator());
    }

    protected static class TestSharedObjectCreator
    implements ISharedObjectCreator<TestCompositeObject> {
        protected TestSharedObjectCreator() {
        }

        @Override
        public TestSharedObject create(Collection<ISharedProperty> properties) {
            return new TestSharedObjectImpl(properties);
        }
    }

    protected static interface ISharedObjectCreator<T extends ICompositeWorldObject> {
        public ISharedWorldObject create(Collection<ISharedProperty> var1);
    }
}

