/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogEnvelope;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogManager;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkLogClient {
    private Listeners<ILoggingStartedListener> loggingStartedCallback = new Listeners();
    private Listeners.AdaptableListenerNotifier<ILoggingStartedListener> loggingStartedNotifier = new Listeners.AdaptableListenerNotifier();
    private Listeners<ILogReadListener> logReadCallback = new Listeners();
    private Listeners.AdaptableListenerNotifier<ILogReadListener> logReadNotifier = new Listeners.AdaptableListenerNotifier();
    private Listeners<ILoggingStoppedListener> loggingStoppedCallback = new Listeners();
    private Listeners.AdaptableListenerNotifier<ILoggingStoppedListener> loggingStoppedNotifier = new Listeners.AdaptableListenerNotifier();
    private String address;
    private int port;
    private String agentId;
    protected LogCategory log = new LogCategory("NetworkLogClient");
    private boolean implicitRemoveListeners = true;
    protected LogReadingWorker logReadingWorker = null;
    protected Thread workerThread = null;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public NetworkLogClient(String address, int port, String agentId) {
        this.log.addConsoleHandler();
        String logLevel = Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_NETWORK_LOG_MANAGER_AND_CLIENT_LEVEL.getKey());
        if (logLevel != null) {
            this.log.setLevel(Level.parse(logLevel));
        } else {
            this.log.setLevel(Level.WARNING);
        }
        this.address = address;
        this.port = port;
        this.agentId = agentId;
        this.logReadingWorker = new LogReadingWorker();
        this.loggingStartedCallback.setLog((Logger)this.log, "LoggingStarted");
        this.logReadCallback.setLog((Logger)this.log, "LogRead");
        this.loggingStoppedCallback.setLog((Logger)this.log, "LoggingStopped");
    }

    public LogCategory getLogger() {
        return this.log;
    }

    public void setImplicitRemoveListeners(boolean state) {
        this.implicitRemoveListeners = state;
    }

    public boolean isImplicitRemoveListeners() {
        return this.implicitRemoveListeners;
    }

    public boolean isException() {
        LogReadingWorker worker = this.logReadingWorker;
        return worker != null && worker.exception != null;
    }

    public Throwable getException() {
        LogReadingWorker worker = this.logReadingWorker;
        return worker == null ? null : worker.exception;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public synchronized void start() {
        this.log.warning("Starting for " + this.agentId + " @ " + this.address + ":" + this.port);
        if (((Boolean)this.logReadingWorker.running.getFlag()).booleanValue()) {
            this.log.warning("Old connection is still up... closing.");
            this.stop();
            this.log.warning("Resuming start for " + this.agentId + " @ " + this.address + ":" + this.port);
        }
        this.workerThread = new Thread((Runnable)this.logReadingWorker, "NetworkLogClient-" + this.address + ":" + this.port);
        this.workerThread.start();
        this.logReadingWorker.connected.waitFor((Object[])new Boolean[]{true, false});
        if (!((Boolean)this.logReadingWorker.connected.getFlag()).booleanValue()) {
            throw new PogamutException("Could not start reading logs from the network.", this.logReadingWorker.exception, (Object)this);
        }
    }

    public synchronized void stop() {
        this.log.warning("Stopping for " + this.agentId + " @ " + this.address + ":" + this.port);
        if (this.logReadingWorker != null && ((Boolean)this.logReadingWorker.running.getFlag()).booleanValue()) {
            this.logReadingWorker.kill();
            this.logReadingWorker.running.waitFor((Object[])new Boolean[]{false});
        }
    }

    public Flag<Boolean> getRunning() {
        return this.logReadingWorker.running;
    }

    public Flag<Boolean> getConnected() {
        return this.logReadingWorker.connected;
    }

    public void addListener(ILoggingStartedListener listener) {
        this.loggingStartedCallback.addStrongListener((EventListener)((Object)listener));
    }

    public void removeListener(ILoggingStartedListener listener) {
        this.loggingStartedCallback.removeListener((EventListener)((Object)listener));
    }

    public void addListener(ILoggingStoppedListener listener) {
        this.loggingStoppedCallback.addStrongListener((EventListener)((Object)listener));
    }

    public void removeListener(ILoggingStoppedListener listener) {
        this.loggingStoppedCallback.removeListener((EventListener)((Object)listener));
    }

    public void addListener(ILogReadListener listener) {
        this.logReadCallback.addStrongListener((EventListener)((Object)listener));
    }

    public void removeListener(ILogReadListener listener) {
        this.logReadCallback.removeListener((EventListener)((Object)listener));
    }

    private String checkLineEnd(String msg) {
        if (msg == null) {
            return null;
        }
        if (NEW_LINE.length() == 2) {
            return msg;
        }
        if (msg.charAt(msg.length() - 1) == '\r') {
            return msg.substring(0, msg.length() - 1);
        }
        return msg;
    }

    private class LogReadingWorker
    implements Runnable {
        private volatile boolean shouldRun = true;
        public volatile Flag<Boolean> running = new Flag((Object)false);
        public volatile Flag<Boolean> connected = new Flag(null);
        private volatile boolean exceptionExpected = false;
        public volatile Throwable exception = null;
        private Thread myThread = null;

        private LogReadingWorker() {
        }

        public void kill() {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            this.shouldRun = false;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.exceptionExpected = true;
            this.myThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myThread = Thread.currentThread();
            this.exception = null;
            this.shouldRun = true;
            this.exceptionExpected = false;
            this.running.setFlag((Object)true);
            this.connected.setFlag(null);
            NetworkLogClient.this.log.info("LogReadingWorker: Started.");
            AbstractInterruptibleChannel socket = null;
            try {
                socket = SocketChannel.open(new InetSocketAddress(NetworkLogClient.this.address, NetworkLogClient.this.port));
            }
            catch (IOException e1) {
                try {
                    socket.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                NetworkLogClient.this.log.severe("LogReadingWorker: Could not open socket for " + NetworkLogClient.this.address + ":" + NetworkLogClient.this.port + ".");
                socket = null;
                this.exception = e1;
                NetworkLogClient.this.loggingStoppedNotifier.setEvent((Object)new LoggingStopped((Throwable)new PogamutIOException("Could not open " + NetworkLogClient.this.address + ":" + NetworkLogClient.this.port + ".", (Throwable)e1)));
                NetworkLogClient.this.loggingStoppedCallback.notifySafe((Listeners.ListenerNotifier)NetworkLogClient.this.loggingStoppedNotifier, (Logger)NetworkLogClient.this.log);
                this.connected.setFlag((Object)false);
                this.running.setFlag((Object)false);
                NetworkLogClient.this.log.warning("LogReadingWorker stopped.");
                return;
            }
            NetworkLogClient.this.log.fine("LogReadingWorker: Socket opened for " + NetworkLogClient.this.address + ":" + NetworkLogClient.this.port + ".");
            CharsetEncoder encoder = NetworkLogManager.USED_CHARSET.newEncoder();
            CharsetDecoder decoder = NetworkLogManager.USED_CHARSET.newDecoder();
            PrintWriter writer = new PrintWriter(Channels.newWriter((WritableByteChannel)((Object)socket), encoder, -1));
            BufferedReader reader = new BufferedReader(Channels.newReader((ReadableByteChannel)((Object)socket), decoder, -1));
            try {
                writer.println(NetworkLogClient.this.agentId);
                writer.flush();
            }
            catch (Exception e1) {
                try {
                    socket.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                socket = null;
                this.exception = e1;
                NetworkLogClient.this.loggingStoppedNotifier.setEvent((Object)new LoggingStopped((Throwable)new PogamutIOException("Could not send 'agent id' to " + NetworkLogClient.this.address + ":" + NetworkLogClient.this.port + ".", (Throwable)e1)));
                NetworkLogClient.this.loggingStoppedCallback.notifySafe((Listeners.ListenerNotifier)NetworkLogClient.this.loggingStoppedNotifier, (Logger)NetworkLogClient.this.log);
                this.connected.setFlag((Object)false);
                this.running.setFlag((Object)false);
                NetworkLogClient.this.log.warning("LogReadingWorker: stopped.");
                return;
            }
            NetworkLogClient.this.log.fine("LogReadingWorker: Agent id sent.");
            NetworkLogClient.this.loggingStartedNotifier.setEvent((Object)new LoggingStarted());
            NetworkLogClient.this.loggingStartedCallback.notify((Listeners.ListenerNotifier)NetworkLogClient.this.loggingStartedNotifier);
            NetworkLogClient.this.log.fine("LogReadingWorker: Starting reading logs.");
            try {
                StringBuffer message = new StringBuffer();
                this.connected.setFlag((Object)true);
                String category = null;
                String level = null;
                String time = null;
                while (this.shouldRun && !this.myThread.isInterrupted()) {
                    try {
                        try {
                            String msg;
                            category = NetworkLogClient.this.checkLineEnd(reader.readLine());
                            level = NetworkLogClient.this.checkLineEnd(reader.readLine());
                            time = NetworkLogClient.this.checkLineEnd(reader.readLine());
                            if (message.length() > 0) {
                                message.delete(0, message.length());
                            }
                            boolean first = true;
                            while (!(msg = NetworkLogClient.this.checkLineEnd(reader.readLine())).equals("</end>")) {
                                if (first) {
                                    first = false;
                                } else {
                                    message.append(NEW_LINE);
                                }
                                message.append(msg);
                            }
                        }
                        catch (Exception e) {
                            NetworkLogClient.this.log.severe(ExceptionToString.process((String)"LogReadingWorker: Exception while reading data from the socket, connection closed from the remote side? Shutting down...", (Throwable)e));
                            break;
                        }
                        NetworkLogEnvelope logEnvelope = null;
                        try {
                            logEnvelope = new NetworkLogEnvelope(category, level, time, message.toString());
                        }
                        catch (Exception e) {
                            NetworkLogClient.this.log.warning(ExceptionToString.process((String)("LogReadingWorker: MALFORMED log record, category='" + category + "', level='" + level + "', time='" + time + "', message='" + message + "'"), (Throwable)e));
                            continue;
                        }
                        NetworkLogClient.this.logReadCallback.notify((Listeners.ListenerNotifier)NetworkLogClient.this.logReadNotifier.setEvent((Object)new LogRead(logEnvelope)));
                    }
                    catch (Exception e) {
                        if (!this.exceptionExpected) {
                            NetworkLogClient.this.log.severe(ExceptionToString.process((String)"LogReadingWorker: Exception at LogSendingWorker.", (Throwable)e));
                            this.exception = e;
                        } else {
                            NetworkLogClient.this.log.fine(ExceptionToString.process((String)"LogReadingWorker: Exception at LogSendingWorker, expected.", (Throwable)e));
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!this.exceptionExpected) {
                    NetworkLogClient.this.log.severe(ExceptionToString.process((String)"LogReadingWorker: Exception at LogSendingWorker.", (Throwable)e));
                    this.exception = e;
                } else {
                    NetworkLogClient.this.log.fine(ExceptionToString.process((String)"LogReadingWorker: Exception at LogSendingWorker, expected.", (Throwable)e));
                }
            }
            finally {
                try {
                    socket.close();
                }
                catch (Exception e) {}
                this.connected.setFlag((Object)false);
                this.running.setFlag((Object)false);
                if (this.exception != null) {
                    NetworkLogClient.this.loggingStoppedCallback.notifySafe((Listeners.ListenerNotifier)NetworkLogClient.this.loggingStoppedNotifier.setEvent((Object)new LoggingStopped(this.exception)), (Logger)NetworkLogClient.this.log);
                } else {
                    NetworkLogClient.this.loggingStoppedCallback.notifySafe((Listeners.ListenerNotifier)NetworkLogClient.this.loggingStoppedNotifier.setEvent((Object)new LoggingStopped()), (Logger)NetworkLogClient.this.log);
                }
                if (NetworkLogClient.this.implicitRemoveListeners) {
                    NetworkLogClient.this.log.warning("LogReadingWorker: Removing all listeners...");
                    NetworkLogClient.this.loggingStartedCallback.clearListeners();
                    NetworkLogClient.this.logReadCallback.clearListeners();
                    NetworkLogClient.this.loggingStoppedCallback.clearListeners();
                }
                NetworkLogClient.this.log.warning("LogSendingWorker: Stopped.");
            }
        }
    }

    public static interface ILoggingStoppedListener
    extends IListener<LoggingStopped> {
    }

    public static interface ILogReadListener
    extends IListener<LogRead> {
    }

    public static interface ILoggingStartedListener
    extends IListener<LoggingStarted> {
    }

    public static class LoggingStopped {
        private boolean expected;
        private Throwable exception;

        public LoggingStopped() {
            this.expected = true;
        }

        public LoggingStopped(Throwable e) {
            this.expected = false;
            this.exception = e;
        }

        public Throwable getException() {
            return this.exception;
        }

        public boolean isExpected() {
            return this.expected;
        }

        public boolean isFailure() {
            return !this.expected;
        }
    }

    public static class LogRead {
        private NetworkLogEnvelope record;

        public LogRead(NetworkLogEnvelope record) {
            this.record = record;
        }

        public NetworkLogEnvelope getRecord() {
            return this.record;
        }
    }

    public static class LoggingStarted {
    }
}

