/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.impl.BatchAwareWorldView;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SyncLockableBatchAwareWorldView
extends BatchAwareWorldView
implements ILockableWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "SyncLockableBatchAwareWorldView";
    private Queue<List<IWorldChangeEvent>> batches = new LinkedList<List<IWorldChangeEvent>>();
    private List<IWorldChangeEvent> currentBatch = new ArrayList<IWorldChangeEvent>();
    private boolean locked = false;
    private boolean inLock = false;
    private boolean beginCame = false;
    private final Object objectMutex = new Object();
    private CountDownLatch lockLatch = new CountDownLatch(1);
    private boolean stopRequested = false;

    @Inject
    public SyncLockableBatchAwareWorldView(@Named(value="SyncLockableBatchAwareWorldView") ComponentDependencies dependencies, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() throws PogamutInterruptedException {
        Object object = this.objectMutex;
        synchronized (object) {
            if (this.isLocked()) {
                return;
            }
            this.locked = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view locked.");
            }
        }
        try {
            this.lockLatch.await();
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e.getMessage(), (Throwable)e, (Logger)this.log, (Object)this);
        }
        if (this.stopRequested) {
            throw new PogamutInterruptedException("lock() interrupted with the request to stop the work", (Logger)this.log, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.isLocked()) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view is being unlocked.");
            }
            this.locked = false;
            this.inLock = false;
            this.processBatches();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("World view unlocked.");
            }
            this.lockLatch = new CountDownLatch(1);
        }
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public boolean isInLock() {
        return this.inLock;
    }

    private void processBatches() {
        for (List list : this.batches) {
            this.processBatch(list);
        }
        this.batches.clear();
        this.processBatch(this.currentBatch);
    }

    private void processBatch(List<IWorldChangeEvent> batch) {
        for (IWorldChangeEvent event : batch) {
            super.notify(event);
        }
        batch.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IWorldChangeEvent event) {
        Object object = this.objectMutex;
        synchronized (object) {
            if (!this.beginCame) {
                if (this.isBatchBeginEvent(event)) {
                    this.beginCame = true;
                } else {
                    super.notify(event);
                    return;
                }
            }
            if (this.isLocked()) {
                if (this.isInLock()) {
                    if (this.isBatchEndEvent(event)) {
                        this.currentBatch.add(event);
                        this.batches.add(this.currentBatch);
                        this.currentBatch = new ArrayList<IWorldChangeEvent>(this.currentBatch.size() + 10);
                    } else {
                        this.currentBatch.add(event);
                    }
                } else if (this.isBatchEndEvent(event)) {
                    super.notify(event);
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("World view in-locked state, raising the lock() latch.");
                    }
                    this.lockLatch.countDown();
                    this.inLock = true;
                } else {
                    super.notify(event);
                }
            } else {
                super.notify(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        Object object = this.objectMutex;
        synchronized (object) {
            this.stopRequested = true;
            this.lockLatch.countDown();
        }
    }
}

