/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.future;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.utils.future.ComponentFutureException;
import cz.cuni.amis.utils.future.FutureWithListeners;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ComponentFuture<RESULT>
extends FutureWithListeners<RESULT> {
    private IComponent[] dependants;
    private IComponentBus bus;

    public ComponentFuture(IComponentBus bus, IComponent ... dependants) {
        this.bus = bus;
        this.dependants = dependants;
    }

    protected CountDownLatch createLatch() {
        if (this.bus != null && this.dependants != null && this.dependants.length > 0) {
            return new BusAwareCountDownLatch(1, this.bus, this.dependants);
        }
        return new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESULT get() throws ComponentFutureException {
        super.get();
        Object object = this.mutex;
        synchronized (object) {
            switch (this.getStatus()) {
                case FUTURE_IS_READY: {
                    return (RESULT)super.get();
                }
                case CANCELED: {
                    throw new ComponentFutureException("The computation has been canceled.", (Object)this);
                }
                case COMPUTATION_EXCEPTION: {
                    throw new ComponentFutureException("Computation exception.", this.getException());
                }
                case FUTURE_IS_BEING_COMPUTED: {
                    this.computationException((Exception)((Object)new ComponentNotRunningException("One of the component dealing with the future computation has stopped.", (Object)this)));
                    throw new ComponentFutureException("One of the component has stopped, future can't be computer.", this.getException());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESULT get(long timeout, TimeUnit unit) throws ComponentFutureException {
        super.get(timeout, unit);
        Object object = this.mutex;
        synchronized (object) {
            switch (this.getStatus()) {
                case FUTURE_IS_READY: {
                    return (RESULT)super.get();
                }
                case CANCELED: {
                    throw new ComponentFutureException("The computation has been canceled.", (Object)this);
                }
                case COMPUTATION_EXCEPTION: {
                    throw new ComponentFutureException("Computation exception.", this.getException());
                }
                case FUTURE_IS_BEING_COMPUTED: {
                    if (this.latch.getCount() != 0L) break;
                    this.computationException((Exception)((Object)new ComponentNotRunningException("One of the component dealing with the future computation has stopped.", (Object)this)));
                    throw new ComponentFutureException("One of the component has stopped, future can't be computer.", this.getException());
                }
            }
        }
        return null;
    }
}

