/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.logging.Level;

public abstract class AbstractLogCategories
implements ILogCategories {
    private Map<String, LogCategory> immutableCategories = null;
    private Comparator<String> stringComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                if (o1 == o2) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };

    protected abstract Map<String, LogCategory> getCategoriesInternal();

    @Override
    public boolean hasCategory(String name) {
        return Arrays.binarySearch(this.getCategoryNamesSorted(), name, this.stringComparator) >= 0;
    }

    @Override
    public Map<String, LogCategory> getCategories() {
        if (this.immutableCategories == null) {
            this.immutableCategories = Collections.unmodifiableMap(this.getCategoriesInternal());
        }
        return this.immutableCategories;
    }

    @Override
    public void addLogCategory(String name, LogCategory category) {
        this.getCategoriesInternal().put(name, category);
    }

    @Override
    public String[] getCategoryNames() {
        return this.getCategoriesInternal().keySet().toArray(new String[0]);
    }

    @Override
    public String[] getCategoryNamesSorted() {
        String[] names = this.getCategoryNames();
        Arrays.sort(names, this.stringComparator);
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevel(Level newLevel) {
        Map<String, LogCategory> map = this.getCategories();
        synchronized (map) {
            for (LogCategory category : this.getCategories().values()) {
                category.setLevel(newLevel);
            }
        }
    }
}

