/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.marks;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.io.Serializable;
import java.util.Calendar;
import java.util.logging.Level;

public class LogMapMark
implements Serializable {
    private static int lastAssignedID = 0;
    private final int id;
    private final Level level;
    private final String message;
    private final Location location;
    private final long created;
    private final long duration;
    private Type type;

    private LogMapMark(int id, Level level, String message, Location location, long created, long duration, Type type) {
        this.id = id;
        this.level = level;
        this.message = message;
        this.location = location != null ? new Location(location) : null;
        this.created = created;
        this.duration = duration;
        this.type = type;
    }

    private LogMapMark(Level level, String message, Location location, long created, long duration, Type type) {
        this(++lastAssignedID, level, message, location, created, duration, type);
    }

    public static synchronized LogMapMark createFixedLengthEvent(Level level, String message, Location location, long duration) {
        long time = Calendar.getInstance().getTimeInMillis();
        return new LogMapMark(level, message, location, time, duration, Type.FIXED_DURATION);
    }

    public static synchronized LogMapMark createAgentFixedLengthEvent(Level level, String message, long duration) {
        long time = Calendar.getInstance().getTimeInMillis();
        return new LogMapMark(level, message, null, time, duration, Type.FIXED_DURATION);
    }

    public static synchronized LogMapMark createAgentVariableLengthEvent(Level level, String message) {
        long time = Calendar.getInstance().getTimeInMillis();
        return new LogMapMark(level, message, null, time, Integer.MAX_VALUE, Type.START_EVENT);
    }

    public static synchronized LogMapMark createVariableLengthEvent(Level level, String message, Location location) {
        long time = Calendar.getInstance().getTimeInMillis();
        return new LogMapMark(level, message, location, time, Integer.MAX_VALUE, Type.START_EVENT);
    }

    public boolean equals(Object otherObject) {
        boolean locEqual;
        boolean msgEqual;
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof LogMapMark)) {
            return false;
        }
        LogMapMark other = (LogMapMark)otherObject;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        boolean bl = this.getMessage() == null ? other.getMessage() == null : (msgEqual = this.getMessage().equals(other.getMessage()));
        if (!msgEqual) {
            return false;
        }
        boolean bl2 = this.getLocation() == null ? other.getLocation() == null : (locEqual = this.getLocation().equals(other.getLocation()));
        if (!locEqual) {
            return false;
        }
        if (this.getCreated() != other.getCreated()) {
            return false;
        }
        return this.getDuration() == other.getDuration();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 71 * hash + (this.location != null ? this.location.hashCode() : 0);
        hash = 71 * hash + (int)(this.created ^ this.created >>> 32);
        hash = 71 * hash + (int)(this.duration ^ this.duration >>> 32);
        return hash;
    }

    public int getId() {
        return this.id;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Location getLocation() {
        return this.location != null ? new Location(this.location) : null;
    }

    public Location getLocation(Location entityLoc) {
        Location markLocation = this.getLocation();
        return markLocation != null ? markLocation : new Location(entityLoc);
    }

    public long getCreated() {
        return this.created;
    }

    public long getDuration() {
        return this.duration;
    }

    public Type getType() {
        return this.type;
    }

    public LogMapMark getEndMark() {
        if (this.getType() == Type.START_EVENT || this.getType() == Type.END_EVENT) {
            LogMapMark endMark = new LogMapMark(this.id, this.level, this.message, this.location, this.created, this.duration, Type.END_EVENT);
            return endMark;
        }
        throw new IllegalStateException("Mark is not in a state that can be changed to END_EVENT, it is in " + (Object)((Object)this.getType()));
    }

    public static enum Type {
        FIXED_DURATION,
        START_EVENT,
        END_EVENT;

    }
}

