/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.impl;

import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.impl.VisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import java.util.HashSet;
import java.util.Set;

public abstract class BatchAwareWorldView
extends VisionWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "BatchAwareWorldViewDependency";
    Set<IViewable> lastObjectBatch = new HashSet<IViewable>();
    Set<IViewable> currentObjectBatch = new HashSet<IViewable>();

    public BatchAwareWorldView(@Named(value="BatchAwareWorldViewDependency") ComponentDependencies dependencies, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
    }

    protected abstract boolean isBatchEndEvent(IWorldChangeEvent var1);

    protected abstract boolean isBatchBeginEvent(IWorldChangeEvent var1);

    protected abstract void setDisappearedFlag(IViewable var1);

    protected void batchAwareWorldViewNotify(IWorldChangeEvent event) {
        IViewable viewable;
        if (this.isBatchEndEvent(event)) {
            this.lastObjectBatch.removeAll(this.currentObjectBatch);
            for (IViewable obj : this.lastObjectBatch) {
                this.setDisappearedFlag(obj);
                this.objectUpdated(obj);
                super.objectDisappeared(obj);
            }
            Set<IViewable> swp = this.lastObjectBatch;
            this.lastObjectBatch = this.currentObjectBatch;
            this.currentObjectBatch = swp;
            this.currentObjectBatch.clear();
        } else if (event instanceof IWorldObjectUpdatedEvent && event instanceof IViewable && (viewable = (IViewable)this.get(((IWorldObjectUpdatedEvent)event).getId())) != null && viewable.isVisible()) {
            this.currentObjectBatch.add(viewable);
        }
    }

    @Override
    public synchronized void notify(IWorldChangeEvent event) {
        this.batchAwareWorldViewNotify(event);
        super.notify(event);
    }

    @Override
    public synchronized void notifyImmediately(IWorldChangeEvent event) throws ComponentNotRunningException, ComponentPausedException {
        this.batchAwareWorldViewNotify(event);
        super.notifyImmediately(event);
    }

    @Override
    protected void objectAppeared(IViewable obj) {
        super.objectAppeared(obj);
        this.currentObjectBatch.add(obj);
    }

    @Override
    protected void objectDisappeared(IViewable obj) {
        super.objectDisappeared(obj);
        this.lastObjectBatch.remove(obj);
        this.currentObjectBatch.remove(obj);
    }

    public boolean hasObjectsToProcess() {
        return !this.currentObjectBatch.isEmpty();
    }
}

