/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.jmx;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.logging.LogRecord;

public class JMXLogRecordContainer
implements Serializable {
    private LogRecord record;
    private LinkedList parameters = new LinkedList();

    public JMXLogRecordContainer(LogRecord record) {
        this.record = record;
        Object[] allParameters = record.getParameters();
        if (allParameters != null) {
            for (Object parameter : allParameters) {
                if (!Serializable.class.isAssignableFrom(parameter.getClass())) continue;
                this.parameters.add(parameter);
            }
        }
    }

    public void printInfo() {
        System.out.println("JMXContainer record: " + this.record + ", " + this.parameters.size() + " parameters");
        for (Object o : this.parameters) {
            System.out.println(" * " + o);
        }
    }

    public LogRecord getRecordWithParameters() {
        this.record.setParameters(this.parameters.toArray());
        return this.record;
    }
}

