/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.impl;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.MockAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.module.MockModule;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateInstantiated;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateResumed;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateStartedPaused;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.Test;

public class Test06_AbstractAgent_StartPaused_WithModule
extends BaseTest {
    @Test
    public void test() {
        int i;
        AgentId agentId = new AgentId("Test");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.setLevel(Level.ALL);
        logger.addDefaultConsoleHandler();
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        MockAgent agent = new MockAgent((IAgentId)agentId, (IComponentBus)bus, (IAgentLogger)logger);
        MockModule module = new MockModule((IAgent)agent);
        Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(new Class[]{IAgentStateDown.class}));
        Assert.assertTrue((String)"agent not in instantiated-state", (boolean)agent.inState(new Class[]{IAgentStateInstantiated.class}));
        Assert.assertTrue((String)"module not in instantiated-state", (module.getState().getFlag() == ComponentState.INSTANTIATED ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            agent.startPaused();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
            Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(new Class[]{IAgentStatePaused.class}));
            Assert.assertTrue((String)"agent not in started-paused-state", (boolean)agent.inState(new Class[]{IAgentStateStartedPaused.class}));
            Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
            agent.stop();
            Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(new Class[]{IAgentStateDown.class}));
            Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(new Class[]{IAgentStateStopped.class}));
            Assert.assertTrue((String)"module not in stopped-state", (module.getState().getFlag() == ComponentState.STOPPED ? 1 : 0) != 0);
        }
        agent.startPaused();
        Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
        Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(new Class[]{IAgentStatePaused.class}));
        Assert.assertTrue((String)"agent not in started-paused-state", (boolean)agent.inState(new Class[]{IAgentStateStartedPaused.class}));
        Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            agent.resume();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
            Assert.assertTrue((String)"agent not in resumed-state", (boolean)agent.inState(new Class[]{IAgentStateResumed.class}));
            Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
            agent.pause();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
            Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(new Class[]{IAgentStatePaused.class}));
            Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            agent.kill();
            Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(new Class[]{IAgentStateDown.class}));
            Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(new Class[]{IAgentStateFailed.class}));
            Assert.assertTrue((String)"module not in killed-state", (module.getState().getFlag() == ComponentState.KILLED ? 1 : 0) != 0);
            agent.startPaused();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
            Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(new Class[]{IAgentStatePaused.class}));
            Assert.assertTrue((String)"agent not in started-paused-state", (boolean)agent.inState(new Class[]{IAgentStateStartedPaused.class}));
            Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            agent.resume();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
            Assert.assertTrue((String)"agent not in resumed-state", (boolean)agent.inState(new Class[]{IAgentStateResumed.class}));
            Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
            agent.pause();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
            Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(new Class[]{IAgentStatePaused.class}));
            Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
            agent.kill();
            Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(new Class[]{IAgentStateDown.class}));
            Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(new Class[]{IAgentStateFailed.class}));
            Assert.assertTrue((String)"module not in killed-state", (module.getState().getFlag() == ComponentState.KILLED ? 1 : 0) != 0);
            agent.startPaused();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(new Class[]{IAgentStateUp.class}));
            Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(new Class[]{IAgentStatePaused.class}));
            Assert.assertTrue((String)"agent not in started-paused-state", (boolean)agent.inState(new Class[]{IAgentStateStartedPaused.class}));
            Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
        }
        agent.stop();
        Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(new Class[]{IAgentStateDown.class}));
        Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(new Class[]{IAgentStateStopped.class}));
        Assert.assertTrue((String)"module not in stopped-state", (module.getState().getFlag() == ComponentState.STOPPED ? 1 : 0) != 0);
        System.out.println("---/// TEST OK ///---");
    }
}

