/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.network;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class JMXNetworkLoggingAgent
extends AbstractAgent {
    public IAgentLogic myLogic = new IAgentLogic(){

        public long getLogicInitializeTime() {
            return 1000L;
        }

        public long getLogicShutdownTime() {
            return 1000L;
        }

        public void logic() {
            if (JMXNetworkLoggingAgent.this.logicCycles == -1) {
                return;
            }
            if (JMXNetworkLoggingAgent.this.logicCycles == 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JMXNetworkLoggingAgent.this.stop();
                    }
                }).start();
                --JMXNetworkLoggingAgent.this.logicCycles;
                return;
            }
            if (JMXNetworkLoggingAgent.this.logicLatch != null) {
                try {
                    JMXNetworkLoggingAgent.this.logicLatch.await();
                    JMXNetworkLoggingAgent.this.logicLatch = null;
                    System.out.println("(" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") [INFO] Logic latched dropped, waiting 1 sec to let the NetworkLogManger to catch the NetworkLogClient connection...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException((Throwable)e, (Object)this);
                }
                System.out.println("(" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") [INFO] About to send first logs...");
            }
            for (int i = 0; i < JMXNetworkLoggingAgent.this.logsPerLogicCycle; ++i) {
                JMXNetworkLoggingAgent.this.getLogger().getCategory("my-log").finest("!!! (" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") I'm alive! FINEST - " + i);
                JMXNetworkLoggingAgent.this.getLogger().getCategory("my-log").finer("!!! (" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") I'm alive! FINER - " + i);
                JMXNetworkLoggingAgent.this.getLogger().getCategory("my-log").fine("!!! (" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") I'm alive! FINE - " + i);
                JMXNetworkLoggingAgent.this.getLogger().getCategory("my-log").info("!!! (" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") I'm alive! INFO - " + i);
                JMXNetworkLoggingAgent.this.getLogger().getCategory("my-log").warning("!!! (" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") I'm alive! WARNING - " + i);
                JMXNetworkLoggingAgent.this.getLogger().getCategory("my-log").severe("!!! (" + JMXNetworkLoggingAgent.this.getComponentId().getToken() + ") I'm alive! SEVERE - " + i);
            }
            --JMXNetworkLoggingAgent.this.logicCycles;
        }

        public void logicInitialize(LogicModule logicModule) {
            JMXNetworkLoggingAgent.this.logicLatch = new CountDownLatch(1);
            JMXNetworkLoggingAgent.this.logicCycles = JMXNetworkLoggingAgent.this.origLogicCycles;
        }

        public void logicShutdown() {
        }

        public void beforeFirstLogic() {
        }
    };
    private LogicModule logic = new LogicModule((IAgent)this, this.myLogic);
    private int logsPerLogicCycle;
    private int logicCycles;
    private CountDownLatch logicLatch;
    private int origLogicCycles;

    public CountDownLatch getLogicLatch() {
        return this.logicLatch;
    }

    public JMXNetworkLoggingAgent(IAgentId agentId, IAgentLogger logger, double logicFrequency, int logsPerLogicCycle, int logicCycles) {
        super(agentId, (IComponentBus)new ComponentBus(logger), logger);
        this.logic.setLogicFrequency(logicFrequency);
        this.log.setLevel(Level.ALL);
        this.logsPerLogicCycle = logsPerLogicCycle;
        this.logicCycles = logicCycles;
        this.origLogicCycles = logicCycles;
    }
}

