/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.agent.impl.TeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.BatchAwareLocalWorldView;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.pogamut.multi.worldview.events.BatchBeginEventStub;
import cz.cuni.amis.pogamut.multi.worldview.events.BatchEndEventStub;
import cz.cuni.amis.pogamut.multi.worldview.stub.BatchAwareLocalWVStub;
import cz.cuni.amis.pogamut.multi.worldview.stub.BatchAwareSharedWVStub;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import java.util.logging.Level;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class Test06_BatchAwareWorldView_StoppingTest
extends BaseTest {
    protected BatchAwareSharedWVStub createSWV() {
        return new BatchAwareSharedWVStub(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        log.info("Shared worldview...");
        BatchAwareSharedWVStub swv = this.createSWV();
        TeamedAgentId agentId = new TeamedAgentId("Agent1", "RED");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.setLevel(Level.ALL);
        logger.addDefaultConsoleHandler();
        LifecycleBus bus = new LifecycleBus((IAgentLogger)logger);
        ComponentStub starter = new ComponentStub((IAgentLogger)logger, (IComponentBus)bus);
        BatchAwareLocalWVStub agentWV = new BatchAwareLocalWVStub(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)starter), (ILifecycleBus)bus, (IAgentLogger)logger, (ISharedWorldView)swv, (ITeamedAgentId)agentId);
        AgentLogicStub agent = new AgentLogicStub(agentWV);
        int iters = 500;
        int batches = 5;
        int time = 0;
        long batchLength = 5L;
        Thread agentThread = null;
        try {
            for (int i = 0; i < iters; ++i) {
                log.info("---- ITERATION: " + (i + 1) + " / " + iters + " ----");
                agentThread = new Thread((Runnable)agent, "AgentThread");
                log.info("Starting agent...");
                starter.getController().manualStart("Start!");
                log.info("Starting agent logic thread...");
                agentThread.start();
                log.info("Waiting for the agent logic to start for 5 secs...");
                agent.isRunning.waitFor(5000L, (Object[])new Boolean[]{true});
                if (!agentWV.isRunning()) {
                    throw new RuntimeException("BatchAwareLocalWorldView is NOT running!!!");
                }
                if (!((Boolean)agent.isRunning.getFlag()).booleanValue()) {
                    throw new RuntimeException("Agent logic thread is not running after start!!!");
                }
                log.info("Logic is running...");
                int nextEnd = time + batches;
                while (time < nextEnd) {
                    log.info("--- Batch " + (batches - (nextEnd - time - 1)) + " / " + batches);
                    agentWV.notify(new BatchBeginEventStub(time));
                    try {
                        Thread.sleep(batchLength);
                    }
                    catch (InterruptedException e) {
                        throw new PogamutInterruptedException((Throwable)e, (Object)this);
                    }
                    agentWV.notify(new BatchEndEventStub(time));
                    ++time;
                }
                log.info("Stopping agent...");
                starter.getController().manualStop("Stop!");
                log.info("Waiting for the agent logic to stop as well for 5 secs...");
                agent.isRunning.waitFor(5000L, (Object[])new Boolean[]{false});
                if (agentWV.isRunning()) {
                    throw new RuntimeException("BatchAwareLocalWorldView is running!!!");
                }
                if (((Boolean)agent.isRunning.getFlag()).booleanValue()) {
                    throw new RuntimeException("Agent logic thread is STILL ALIVE after stop!!!");
                }
                if (agent.failure) {
                    throw new RuntimeException("Agent has reported failure!!!");
                }
                log.info("Agent logic has stopped...");
            }
        }
        finally {
            block33: {
                try {
                    starter.getController().manualKill("TERMINATION!");
                    if (agentThread == null) break block33;
                    agentThread.interrupt();
                }
                catch (Throwable throwable) {
                    try {
                        TimeKeyManager.get().unlockAll();
                    }
                    catch (Exception e) {}
                    try {
                        TimeKey.clear();
                    }
                    catch (Exception e) {}
                    throw throwable;
                }
            }
            try {
                TimeKeyManager.get().unlockAll();
            }
            catch (Exception e) {}
            try {
                TimeKey.clear();
            }
            catch (Exception e) {}
        }
    }

    private class AgentLogicStub
    implements Runnable {
        private TeamedAgentId agentId;
        private volatile boolean shouldRun = true;
        private volatile Flag<Boolean> isRunning = new Flag((Object)false);
        private volatile boolean failure = false;
        private volatile Throwable cause = null;
        private BatchAwareLocalWorldView localWV;

        public AgentLogicStub(BatchAwareLocalWorldView localWV) {
            this.agentId = (TeamedAgentId)localWV.getAgentId();
            this.localWV = localWV;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info(this.agentId + "-Logic: STARTING LOGIC");
            this.isRunning.setFlag((Object)true);
            try {
                while (true) {
                    log.info(this.agentId + "-Logic: Locking worldview...");
                    this.localWV.lock();
                    log.info(this.agentId + "-Logic: Unlocking worldview...");
                    this.localWV.unlock();
                }
            }
            catch (ComponentNotRunningException cnre) {
                this.isRunning.setFlag((Object)false);
            }
            catch (Exception e) {
                try {
                    this.cause = e;
                    this.failure = true;
                    log.severe(ExceptionToString.process((String)(this.agentId + "-Logic: FAILURE."), (Throwable)e));
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.isRunning.setFlag((Object)false);
                }
            }
            log.info(this.agentId + "-Logic: END");
        }
    }
}

