/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LongProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.StringProperty;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestCompositeObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestLocalObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestSharedObject;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestStaticObject;
import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.HashMap;
import java.util.Map;

public class TestCompositeObjectMessage
extends TestCompositeObject {
    private static FlagInteger instances = new FlagInteger(Integer.valueOf(0));
    protected long time;
    protected String localString;
    protected Long localLong;
    protected String sharedString;
    protected Long sharedLong;
    protected String staticString;
    protected Long staticLong;

    public static ImmutableFlag<Integer> getInstances() {
        return instances.getImmutable();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        instances.decrement(1);
    }

    public TestCompositeObjectMessage(WorldObjectId id, long time, String localString, Long localLong, String sharedString, long sharedLong, String staticString, Long staticLong) {
        super(id);
        instances.increment(1);
        this.localString = localString;
        this.localLong = localLong;
        this.sharedString = sharedString;
        this.sharedLong = sharedLong;
        this.staticLong = staticLong;
        this.staticString = staticString;
        this.time = time;
    }

    public long getSimTime() {
        return this.time;
    }

    @Override
    public String getLocalString() {
        return this.localString;
    }

    @Override
    public long getLocalLong() {
        return this.localLong;
    }

    @Override
    public String getStaticString() {
        return this.staticString;
    }

    @Override
    public long getStaticLong() {
        return this.staticLong;
    }

    @Override
    public String getSharedString() {
        return this.sharedString;
    }

    @Override
    public long getSharedLong() {
        return this.sharedLong;
    }

    public ILocalWorldObject getLocal() {
        return new TestLocalObjectMessage();
    }

    public ISharedWorldObject getShared() {
        return new TestSharedObjectMessage();
    }

    public IStaticWorldObject getStatic() {
        return new TestStaticObjectMessage();
    }

    protected class TestStaticObjectMessage
    extends TestStaticObject {
        public TestStaticObjectMessage() {
            super(TestCompositeObjectMessage.this.id, TestCompositeObjectMessage.this.getSimTime());
        }

        @Override
        public String getStaticString() {
            return TestCompositeObjectMessage.this.staticString;
        }

        @Override
        public long getStaticLong() {
            return TestCompositeObjectMessage.this.staticLong;
        }

        public boolean isDifferentFrom(IStaticWorldObject other) {
            return this.equals(other);
        }
    }

    protected class TestSharedObjectMessage
    extends TestSharedObject {
        LongProperty longProp;
        StringProperty stringProp;
        HashMap<PropertyId, ISharedProperty> hMap;

        TestSharedObjectMessage() {
            super(TestCompositeObjectMessage.this.id, TestCompositeObjectMessage.this.time);
            this.hMap = new HashMap(2);
            this.longProp = new LongProperty(TestCompositeObjectMessage.this.id, "LongProperty", TestCompositeObjectMessage.this.sharedLong, TestCompositeObject.class);
            this.stringProp = new StringProperty(TestCompositeObjectMessage.this.id, "StrignProp", TestCompositeObjectMessage.this.sharedString, TestCompositeObject.class);
            this.hMap.put(this.longProp.getPropertyId(), (ISharedProperty)this.longProp);
            this.hMap.put(this.stringProp.getPropertyId(), (ISharedProperty)this.stringProp);
        }

        public ISharedProperty getProperty(PropertyId id) {
            return this.hMap.get(id);
        }

        public Map<PropertyId, ISharedProperty> getProperties() {
            return this.hMap;
        }

        @Override
        public TestSharedObject clone() {
            return this;
        }

        @Override
        public String getSharedString() {
            return (String)this.stringProp.getValue();
        }

        @Override
        public long getSharedLong() {
            return (Long)this.longProp.getValue();
        }
    }

    protected class TestLocalObjectMessage
    extends TestLocalObject {
        public TestLocalObjectMessage() {
            super(TestCompositeObjectMessage.this.id, TestCompositeObjectMessage.this.time);
        }

        @Override
        public String getLocalString() {
            return TestCompositeObjectMessage.this.localString;
        }

        @Override
        public long getLocalLong() {
            return TestCompositeObjectMessage.this.localLong;
        }

        @Override
        public TestLocalObject clone() {
            return this;
        }
    }
}

