/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldChangeEventInput;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.WorldEventsMatcher;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.stubs.AbstractEventStub;
import cz.cuni.amis.pogamut.base.communication.worldview.stubs.AbstractObjectStub;
import cz.cuni.amis.pogamut.base.communication.worldview.stubs.MediatorStub;
import cz.cuni.amis.pogamut.base.communication.worldview.stubs.ObjectDestroyedEventStub;
import cz.cuni.amis.pogamut.base.communication.worldview.stubs.ObjectUpdatedEventStub;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import junit.framework.Assert;
import org.easymock.EasyMock;

public class EventDrivenWorldViewTester {
    protected IAgentLogger logger;
    protected LogCategory log;
    protected MediatorStub mediator;
    protected IWorldView worldView;
    protected Map<WorldObjectId, IWorldObject> existingObjects = new HashMap<WorldObjectId, IWorldObject>();
    protected Map<Class, IWorldEventListener> levelAListeners = new LazyMap<Class, IWorldEventListener>(){

        protected IWorldEventListener create(Class key) {
            return (IWorldEventListener)EasyMock.createStrictMock(IWorldEventListener.class);
        }
    };
    protected Map<Class, IWorldObjectListener> levelBListeners = new LazyMap<Class, IWorldObjectListener>(){

        protected IWorldObjectListener create(Class key) {
            return (IWorldObjectListener)EasyMock.createStrictMock(IWorldObjectListener.class);
        }
    };
    protected Map<Class, Map<Class, IWorldObjectListener>> levelCListeners = new LazyMap<Class, Map<Class, IWorldObjectListener>>(){

        protected Map<Class, IWorldObjectListener> create(Class key) {
            return new LazyMap<Class, IWorldObjectListener>(){

                protected IWorldObjectListener create(Class key) {
                    return (IWorldObjectListener)EasyMock.createStrictMock(IWorldObjectListener.class);
                }
            };
        }
    };
    protected Map<WorldObjectId, IWorldObjectListener> levelDListeners = new LazyMap<WorldObjectId, IWorldObjectListener>(){

        protected IWorldObjectListener create(WorldObjectId key) {
            return (IWorldObjectListener)EasyMock.createStrictMock(IWorldObjectListener.class);
        }
    };
    protected Map<WorldObjectId, Map<Class, IWorldObjectListener>> levelEListeners = new LazyMap<WorldObjectId, Map<Class, IWorldObjectListener>>(){

        protected Map<Class, IWorldObjectListener> create(WorldObjectId key) {
            return new LazyMap<Class, IWorldObjectListener>(){

                protected IWorldObjectListener create(Class key) {
                    return (IWorldObjectListener)EasyMock.createStrictMock(IWorldObjectListener.class);
                }
            };
        }
    };
    protected Map<Class, IWorldObjectListener> firstEncounteredListeners = new LazyMap<Class, IWorldObjectListener>(){

        protected IWorldObjectListener create(Class key) {
            return (IWorldObjectListener)EasyMock.createStrictMock(IWorldObjectListener.class);
        }
    };
    protected Map<Class, IWorldObjectListener> updateListeners = new LazyMap<Class, IWorldObjectListener>(){

        protected IWorldObjectListener create(Class key) {
            return (IWorldObjectListener)EasyMock.createStrictMock(IWorldObjectListener.class);
        }
    };
    protected Map<Class, IWorldObjectListener> destroyedListeners = new LazyMap<Class, IWorldObjectListener>(){

        protected IWorldObjectListener create(Class key) {
            return (IWorldObjectListener)EasyMock.createStrictMock(IWorldObjectListener.class);
        }
    };
    private ComponentController worldViewStarter;

    public EventDrivenWorldViewTester(IAgentLogger logger, MediatorStub mediator, IWorldView worldView, ComponentController worldViewStarter) {
        this.logger = logger;
        this.log = logger.getCategory("test");
        this.mediator = mediator;
        this.worldView = worldView;
        this.mediator.setConsumer((IWorldChangeEventInput)this.worldView);
        this.worldViewStarter = worldViewStarter;
    }

    protected void configureEvent(AbstractEventStub event) {
        this.levelAListeners.get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(AbstractEventStub.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(event.getClass()).notify((Object)WorldEventsMatcher.eqEvent(event));
    }

    protected void configureObjectFirstEncountered(WorldObjectFirstEncounteredEvent event) {
        this.levelAListeners.get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(WorldObjectFirstEncounteredEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelBListeners.get(event.getObject().getClass()).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(WorldObjectFirstEncounteredEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelDListeners.get(event.getId()).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(WorldObjectFirstEncounteredEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
    }

    protected void configureObjectUpdated(WorldObjectUpdatedEvent event) {
        this.levelAListeners.get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(WorldObjectUpdatedEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelBListeners.get(event.getObject().getClass()).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(WorldObjectUpdatedEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelDListeners.get(event.getId()).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(WorldObjectUpdatedEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
    }

    protected void configureObjectDestroyed(WorldObjectDestroyedEvent event) {
        this.levelAListeners.get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelAListeners.get(WorldObjectDestroyedEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelBListeners.get(event.getObject().getClass()).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelCListeners.get(event.getObject().getClass()).get(WorldObjectDestroyedEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelDListeners.get(event.getId()).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(IWorldEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(IWorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(WorldObjectEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
        this.levelEListeners.get(event.getId()).get(WorldObjectDestroyedEvent.class).notify((Object)WorldEventsMatcher.eqEvent(event));
    }

    protected void preconfigureEvent(AbstractEventStub event) {
        this.mediator.pushEvent(event);
        this.configureEvent(event);
    }

    protected void preconfigureObject(AbstractObjectStub object) {
        ObjectUpdatedEventStub updated = new ObjectUpdatedEventStub(object);
        this.mediator.pushEvent((IWorldChangeEvent)updated);
        WorldObjectUpdatedEvent updatedEvent = new WorldObjectUpdatedEvent((IWorldObject)object, 0L);
        if (this.existingObjects.containsKey(object.getId())) {
            this.configureObjectUpdated(updatedEvent);
        } else {
            WorldObjectFirstEncounteredEvent encounteredEvent = new WorldObjectFirstEncounteredEvent((IWorldObject)object, object.getSimTime());
            this.configureObjectFirstEncountered(encounteredEvent);
            this.configureObjectUpdated(updatedEvent);
        }
        this.existingObjects.put(object.getId(), object);
    }

    protected void preconfigureObjectDestroyed(ObjectDestroyedEventStub event) {
        if (!this.existingObjects.containsKey(event.getId())) {
            Assert.fail((String)("Can't destroy object of id " + event.getId() + " as it does not currently exists."));
        }
        this.mediator.pushEvent((IWorldChangeEvent)event);
        IWorldObject object = this.existingObjects.remove(event.getId());
        WorldObjectDestroyedEvent destroyedEvent = new WorldObjectDestroyedEvent(object, event.getSimTime());
        this.configureObjectDestroyed(destroyedEvent);
    }

    protected void configuration(Object[] eventsObjects) {
        for (Object obj : eventsObjects) {
            if (obj instanceof AbstractObjectStub) {
                this.preconfigureObject((AbstractObjectStub)obj);
                continue;
            }
            if (obj instanceof AbstractEventStub) {
                this.preconfigureEvent((AbstractEventStub)obj);
                continue;
            }
            if (!(obj instanceof ObjectDestroyedEventStub)) continue;
            this.preconfigureObjectDestroyed((ObjectDestroyedEventStub)obj);
        }
    }

    protected void registerListeners() {
        for (Map.Entry<Class, IWorldEventListener> entry : this.levelAListeners.entrySet()) {
            this.worldView.addEventListener(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class, IWorldEventListener> entry : this.levelBListeners.entrySet()) {
            this.worldView.addObjectListener(entry.getKey(), (IWorldObjectEventListener)entry.getValue());
        }
        for (Map.Entry<Class, Object> entry : this.levelCListeners.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                this.worldView.addObjectListener(entry.getKey(), (Class)entry2.getKey(), (IWorldObjectEventListener)entry2.getValue());
            }
        }
        for (Map.Entry<Class, Object> entry : this.levelDListeners.entrySet()) {
            this.worldView.addObjectListener((WorldObjectId)entry.getKey(), (IWorldObjectEventListener)entry.getValue());
        }
        for (Map.Entry<Class, Object> entry : this.levelEListeners.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                this.worldView.addObjectListener((WorldObjectId)entry.getKey(), (Class)entry2.getKey(), (IWorldObjectEventListener)entry2.getValue());
            }
        }
        for (Map.Entry<Class, Object> entry : this.firstEncounteredListeners.entrySet()) {
            this.worldView.addObjectListener(entry.getKey(), WorldObjectFirstEncounteredEvent.class, (IWorldObjectEventListener)entry.getValue());
        }
        for (Map.Entry<Class, Object> entry : this.updateListeners.entrySet()) {
            this.worldView.addObjectListener(entry.getKey(), WorldObjectUpdatedEvent.class, (IWorldObjectEventListener)entry.getValue());
        }
        for (Map.Entry<Class, Object> entry : this.destroyedListeners.entrySet()) {
            this.worldView.addObjectListener(entry.getKey(), WorldObjectDestroyedEvent.class, (IWorldObjectEventListener)entry.getValue());
        }
    }

    protected void switchToReplay() {
        for (Map.Entry<Class, IWorldEventListener> entry : this.levelAListeners.entrySet()) {
            EasyMock.replay((Object[])new Object[]{entry.getValue()});
        }
        for (Map.Entry<Class, IWorldEventListener> entry : this.levelBListeners.entrySet()) {
            EasyMock.replay((Object[])new Object[]{entry.getValue()});
        }
        for (Map.Entry<Class, Object> entry : this.levelCListeners.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                EasyMock.replay((Object[])new Object[]{entry2.getValue()});
            }
        }
        for (Map.Entry<Class, Object> entry : this.levelDListeners.entrySet()) {
            EasyMock.replay((Object[])new Object[]{entry.getValue()});
        }
        for (Map.Entry<Class, Object> entry : this.levelEListeners.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                EasyMock.replay((Object[])new Object[]{entry2.getValue()});
            }
        }
        for (IWorldObjectListener iWorldObjectListener : this.firstEncounteredListeners.values()) {
            EasyMock.replay((Object[])new Object[]{iWorldObjectListener});
        }
        for (IWorldObjectListener iWorldObjectListener : this.updateListeners.values()) {
            EasyMock.replay((Object[])new Object[]{iWorldObjectListener});
        }
        for (IWorldObjectListener iWorldObjectListener : this.destroyedListeners.values()) {
            EasyMock.replay((Object[])new Object[]{iWorldObjectListener});
        }
    }

    protected void verifyListeners() {
        for (Map.Entry<Class, IWorldEventListener> entry : this.levelAListeners.entrySet()) {
            EasyMock.verify((Object[])new Object[]{entry.getValue()});
        }
        for (Map.Entry<Class, IWorldEventListener> entry : this.levelBListeners.entrySet()) {
            EasyMock.verify((Object[])new Object[]{entry.getValue()});
        }
        for (Map.Entry<Class, Object> entry : this.levelCListeners.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                EasyMock.verify((Object[])new Object[]{entry2.getValue()});
            }
        }
        for (Map.Entry<Class, Object> entry : this.levelDListeners.entrySet()) {
            EasyMock.verify((Object[])new Object[]{entry.getValue()});
        }
        for (Map.Entry<Class, Object> entry : this.levelEListeners.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                EasyMock.verify((Object[])new Object[]{entry2.getValue()});
            }
        }
        for (IWorldObjectListener iWorldObjectListener : this.firstEncounteredListeners.values()) {
            EasyMock.verify((Object[])new Object[]{iWorldObjectListener});
        }
        for (IWorldObjectListener iWorldObjectListener : this.updateListeners.values()) {
            EasyMock.verify((Object[])new Object[]{iWorldObjectListener});
        }
        for (IWorldObjectListener iWorldObjectListener : this.destroyedListeners.values()) {
            EasyMock.verify((Object[])new Object[]{iWorldObjectListener});
        }
    }

    protected void test() {
        try {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Starting worldview...");
            }
            this.worldViewStarter.manualStart("starting worldview");
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Starting mediator...");
            }
            this.mediator.start();
        }
        catch (PogamutException e) {
            e.printStackTrace();
            Assert.fail((String)"WorldView failed to start.");
        }
        this.testBody();
        new WaitForFlagChange(this.mediator.getRunning(), (Object)false).await(900000L, TimeUnit.MILLISECONDS);
        if (this.mediator.getEventQueueLength() != 0) {
            Assert.fail((String)"Mediator failed to process all events in the queue...");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Stopping worldview...");
        }
        this.worldViewStarter.manualStop("Stopping the test.");
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Verifying listeners...");
        }
        this.verifyListeners();
        Assert.assertFalse((String)"Mediator did not stopped.", (boolean)((Boolean)this.mediator.getRunning().getFlag()));
    }

    protected void testBody() {
    }

    public void test(Object[] eventsObjects) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Configuring listeners and mediator...");
        }
        this.configuration(eventsObjects);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Switching listeners to replay...");
        }
        this.switchToReplay();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Registering listeners...");
        }
        this.registerListeners();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Testing...");
        }
        this.test();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Verifying...");
        }
        this.verifyListeners();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("---/// TEST OK ///---");
        }
    }
}

