/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResetEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentBusNotRunningException;
import cz.cuni.amis.pogamut.base.component.stub.component.AutoCheckComponent;
import cz.cuni.amis.pogamut.base.component.stub.component.CheckEvent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.Test;

public class Test01_ComponentBus
extends BaseTest {
    @Test
    public void test01() {
        AgentId agentId = new AgentId("Test01_ComponentBus");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus((IAgentLogger)logger);
        AutoCheckComponent comp1 = new AutoCheckComponent((IAgentLogger)logger, (IComponentBus)bus);
        AutoCheckComponent comp2 = new AutoCheckComponent((IAgentLogger)logger, (IComponentBus)bus);
        IComponentEvent[] events = new IComponentEvent[]{new FatalErrorEvent((IComponent)comp1, "Bad bad!"), new ResetEvent((IComponent)bus), new FatalErrorEvent((IComponent)comp2, "Bad bad!"), new ResetEvent((IComponent)bus), new StartedEvent((IComponent)comp1), new StartedEvent((IComponent)comp2)};
        CheckEvent[] checkEvents = new CheckEvent[events.length];
        for (int i = 0; i < events.length; ++i) {
            checkEvents[i] = new CheckEvent(events[i]);
        }
        comp1.expect(checkEvents);
        comp2.expect(checkEvents);
        bus.event(events[0]);
        Assert.assertTrue((String)"bus should not be running after fatal error", (!bus.isRunning() ? 1 : 0) != 0);
        bus.reset();
        bus.event(events[2]);
        Assert.assertTrue((String)"bus should not be running after fatal error", (!bus.isRunning() ? 1 : 0) != 0);
        boolean exception = false;
        try {
            bus.event((IComponentEvent)new StoppedEvent((IComponent)comp1));
        }
        catch (ComponentBusNotRunningException e) {
            exception = true;
        }
        Assert.assertTrue((String)"bus should NOT throw an exception when the event is sent to stopped bus", (!exception ? 1 : 0) != 0);
        bus.reset();
        bus.event(events[4]);
        bus.event(events[5]);
        comp1.checkExpectEmpty();
        comp2.checkExpectEmpty();
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test01_ComponentBus test = new Test01_ComponentBus();
        test.test01();
    }
}

