/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.network;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.NetworkLogManager;
import cz.cuni.amis.pogamut.base.utils.logging.network.CheckNetworkLogClient;
import cz.cuni.amis.pogamut.base.utils.logging.network.NetworkLoggingAgent;
import java.util.logging.Level;
import org.junit.BeforeClass;

public class NetworkLoggingTest {
    private static int NUMBER = 0;

    @BeforeClass
    public static void setUp() {
        NetworkLogManager.getLog().setLevel(Level.FINER);
    }

    protected NetworkLoggingAgent createNewAgent(double logicFrequency, int logsPerLogicCycle, int logicCycles) {
        AgentId agentId = new AgentId("NetworkLoggingAgent-" + ++NUMBER);
        AgentLogger agentLogger = new AgentLogger((IAgentId)agentId);
        agentLogger.setLevel(Level.ALL);
        return new NetworkLoggingAgent((IAgentId)agentId, (IAgentLogger)agentLogger, logicFrequency, logsPerLogicCycle, logicCycles);
    }

    protected void failure(String failure) {
        System.out.println(failure);
        throw new RuntimeException(failure);
    }

    protected void checkAgent(AbstractAgent agent) {
        System.out.println("[INFO]  Checking agent " + agent.getName());
        if (agent.notInState(new Class[]{IAgentStateDown.class})) {
            this.failure("[ERROR] Agent " + agent.getComponentId().getToken() + " is still running!");
        }
        if (agent.inState(new Class[]{IAgentStateFailed.class})) {
            this.failure("[ERROR] Agent " + agent.getComponentId().getToken() + " failed!");
        }
        System.out.println("[OK]    " + agent.getName() + " OK!");
    }

    protected void checkLogClient(CheckNetworkLogClient logClient, int totalLogsOfOneCategory) {
        System.out.println("[INFO]  Checking network log client: " + logClient.getName());
        System.out.println("[INFO]  Total throughput: " + logClient.getThroughput().getCheckThroughput() + " bytes / s");
        if (((Boolean)logClient.getConnected().getFlag()).booleanValue()) {
            logClient.stop();
            this.failure("[ERROR] Network log client still connected!");
        }
        if (((Boolean)logClient.getRunning().getFlag()).booleanValue()) {
            logClient.stop();
            this.failure("[ERROR] Network log client still running!");
        }
        logClient.checkLogNumber(totalLogsOfOneCategory);
        System.out.println("[OK]    All log records received as anticipated (total " + 6 * totalLogsOfOneCategory + ")!");
        if (logClient.getThroughput().getCheckThroughput() < 500000.0) {
            this.failure("[ERROR] Throughput of the logging is " + logClient.getThroughput().getCheckThroughput() + " B / s < 0.5 MB/s !");
        }
        if (logClient.isException()) {
            System.out.println("[ERROR] Exception occured during reading logs: " + logClient.getException().getMessage());
            throw new RuntimeException("[ERROR] Exception occured during reading logs: " + logClient.getException().getMessage(), logClient.getException());
        }
        System.out.println("[OK]    Throughput is OK!");
        System.out.println("[OK]    " + logClient.getName() + " OK!");
    }
}

