/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.object;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import math.geom3d.Point3D;

public class Location
implements ILocated,
Serializable,
Cloneable {
    public static final Location NONE = new Location(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    public static final Location ZERO = new Location();
    static final long serialVersionUID = -7001866845605943889L;
    public final double x;
    public final double y;
    public final double z;
    private Integer hashCode = null;
    public static final Pattern locationPattern;
    public static final double DISTANCE_ZERO = 1.0E-9;

    public Location clone() {
        return new Location(this);
    }

    public Vector3d asVector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Point3d asPoint3d() {
        return new Point3d(this.x, this.y, this.z);
    }

    public Point3D asPoint3D() {
        return new Point3D(this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Location add(Location l) {
        return new Location(this.x + l.x, this.y + l.y, this.z + l.z);
    }

    public static Location add(Location l1, Location l2) {
        return new Location(l1.x + l2.x, l1.y + l2.y, l1.z + l2.z);
    }

    public Location sub(Location l) {
        return new Location(this.x - l.x, this.y - l.y, this.z - l.z);
    }

    public static Location sub(Location l1, Location l2) {
        return new Location(l1.x - l2.x, l1.y - l2.y, l1.z - l2.z);
    }

    public Location add(Velocity v) {
        return new Location(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public static Location add(Location l, Velocity v) {
        return new Location(l.x + v.x, l.y + v.y, l.z + v.z);
    }

    public Location sub(Velocity v) {
        return new Location(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public static Location sub(Location l, Velocity v) {
        return new Location(l.x - v.x, l.y - v.y, l.z - v.z);
    }

    public Location scale(double d) {
        return new Location(this.x * d, this.y * d, this.z * d);
    }

    public Location interpolate(Location l, double d) {
        double d1 = 1.0 - d;
        return new Location(d1 * this.x + d * l.x, d1 * this.y + d * l.y, d1 * this.z + d * l.z);
    }

    public static Location interpolate(Location l1, Location l2, double d) {
        double d1 = 1.0 - d;
        return new Location(d1 * l1.x + d * l2.x, d1 * l1.y + d * l2.y, d1 * l1.z + d * l2.z);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public static boolean equal(Location l1, Location l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        return l1.equals(l2);
    }

    public boolean equals(Location l, double epsilon) {
        if (l == null) {
            return false;
        }
        double d = this.x - l.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = this.y - l.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = this.z - l.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public static boolean equal(Location l1, Location l2, double epsilon) {
        double d = l1.x - l2.x;
        double d2 = d >= 0.0 ? d : -d;
        if (d2 > epsilon) {
            return false;
        }
        d = l1.y - l2.y;
        double d3 = d >= 0.0 ? d : -d;
        if (d3 > epsilon) {
            return false;
        }
        d = l1.z - l2.z;
        double d4 = d >= 0.0 ? d : -d;
        return !(d4 > epsilon);
    }

    public static Location getAverage(Collection<Location> locations) {
        if (locations.size() == 0) {
            return null;
        }
        Iterator<Location> iter = locations.iterator();
        Location result = new Location(iter.next());
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result.scale(1 / locations.size());
    }

    public double getDistance(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        double dz = l.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double getDistance2D(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getDistance(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        double dz = l2.z - l1.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double getDistanceZ(Location location) {
        return this.z - location.z;
    }

    public static double getDistance2D(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double getDistanceSquare(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        double dz = l.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSquare(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        double dz = l2.z - l1.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double getDistanceL1(Location l) {
        double dx = Math.abs(l.x - this.x);
        double dy = Math.abs(l.y - this.y);
        double dz = Math.abs(l.z - this.z);
        return dx + dy + dz;
    }

    public static double getDistanceL1(Location l1, Location l2) {
        double dx = Math.abs(l2.x - l1.x);
        double dy = Math.abs(l2.y - l1.y);
        double dz = Math.abs(l2.z - l1.z);
        return dx + dy + dz;
    }

    public double getDistanceLinf(Location l) {
        double dx = Math.abs(l.x - this.x);
        double dy = Math.abs(l.y - this.y);
        double dz = Math.abs(l.z - this.z);
        return Math.max(Math.max(dx, dy), dz);
    }

    public static double getDistanceLinf(Location l1, Location l2) {
        double dx = Math.abs(l2.x - l1.x);
        double dy = Math.abs(l2.y - l1.y);
        double dz = Math.abs(l2.z - l1.z);
        return Math.max(Math.max(dx, dy), dz);
    }

    public double getDistancePlane(Location l) {
        double dx = l.x - this.x;
        double dy = l.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double getDistancePlane(Location l1, Location l2) {
        double dx = l2.x - l1.x;
        double dy = l2.y - l1.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public Location getLocation() {
        return this;
    }

    public Point3d getPoint3d() {
        return new Point3d(this.x, this.y, this.z);
    }

    private Location() {
        this(0.0, 0.0, 0.0);
    }

    public Location(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Location(double x, double y) {
        this(x, y, 0.0);
    }

    public Location(Location source) {
        this(source.getX(), source.getY(), source.getZ());
    }

    public Location(String string) {
        Matcher m = locationPattern.matcher(string);
        if (m.find()) {
            String strX = m.group(1);
            String strY = m.group(3);
            String strZ = m.group(5);
            try {
                this.x = Double.parseDouble(strX);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Location, because X-coordinate '" + strX + "' is not a number.");
            }
            try {
                this.y = Double.parseDouble(strY);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Location, because Y-coordinate '" + strY + "' is not a number.");
            }
            try {
                this.z = Double.parseDouble(strZ);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Location, because Z-coordinate '" + strZ + "' is not a number.");
            }
        }
        throw new RuntimeException("String '" + string + "' was not matched as Location.");
    }

    public Location(double[] d) {
        this.x = d.length >= 1 ? d[0] : 0.0;
        this.y = d.length >= 2 ? d[1] : 0.0;
        this.z = d.length >= 3 ? d[2] : 0.0;
    }

    public Location(float[] f) {
        this.x = f.length >= 1 ? (double)f[0] : 0.0;
        this.y = f.length >= 2 ? (double)f[1] : 0.0;
        this.z = f.length >= 3 ? (double)f[2] : 0.0;
    }

    public Location(Tuple3d p) {
        this(p.x, p.y, p.z);
    }

    public Location(Point3D p) {
        this(p.getX(), p.getY(), p.getZ());
    }

    public double dot(Location b) {
        return this.x * b.getX() + this.y * b.getY() + this.z * b.getZ();
    }

    public double dot2D(Location b) {
        return this.x * b.getX() + this.y * b.getY();
    }

    public Location cross(Location b) {
        return new Location(this.y * b.getZ() - this.z * b.getY(), this.z * b.getX() - this.x * b.getZ(), this.x * b.getY() - this.y * b.getX());
    }

    public Location rotateXY(double angle) {
        return this.mul(Rotation.constructXYRot(angle));
    }

    public Location rotateXZ(double angle) {
        return this.mul(Rotation.constructXZRot(angle));
    }

    public Location rotateYZ(double angle) {
        return this.mul(Rotation.constructYZRot(angle));
    }

    public Rotation getRotation(Rotation.Order order) {
        Location this_normalized = this.getNormalized();
        double yaw = 0.0;
        double pitch = 0.0;
        switch (order) {
            case YAW_PITCH_ROLL: 
            case ROLL_YAW_PITCH: 
            case YAW_ROLL_PITCH: {
                yaw = Math.atan2(this_normalized.getY(), Math.sqrt(1.0 - this_normalized.getY() * this_normalized.getY()));
                pitch = Math.atan2(this_normalized.getZ(), this_normalized.getX());
                break;
            }
            case PITCH_YAW_ROLL: 
            case PITCH_ROLL_YAW: 
            case ROLL_PITCH_YAW: {
                pitch = Math.atan2(Math.sqrt(1.0 - this_normalized.getZ() * this_normalized.getZ()), this_normalized.getZ());
                yaw = Math.atan2(this_normalized.getX(), this_normalized.getY());
            }
        }
        return new Rotation(pitch / Math.PI * 32768.0 - 1.0, yaw / Math.PI * 32768.0 - 1.0, 0.0);
    }

    public Rotation getQuatLikeRotationSeq(Rotation.Order order) {
        Location projected = new Location(1.0, 0.0, 0.0);
        double yaw = 0.0;
        double pitch = 0.0;
        switch (order) {
            case ROLL_YAW_PITCH: {
                yaw = Math.atan2(this.getY(), this.getX());
                projected = projected.mul(Rotation.constructXYRot(yaw));
                pitch = Math.atan2(this.getZ(), new Location(this.getX(), this.getY(), 0.0).dot(projected));
                return new Rotation(pitch / Math.PI * 32768.0 - 1.0, yaw / Math.PI * 32768.0 - 1.0, 0.0);
            }
        }
        return Rotation.ZERO;
    }

    public Location getNormalized() {
        return this.scale(1.0 / this.getLength());
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Location mul(Matrix3d matrix) {
        Location res = new Location(matrix.getM00() * this.x + matrix.getM10() * this.y + matrix.getM20() * this.z, matrix.getM01() * this.x + matrix.getM11() * this.y + matrix.getM21() * this.z, matrix.getM02() * this.x + matrix.getM12() * this.y + matrix.getM22() * this.z);
        return res;
    }

    public Location invert() {
        return new Location(-this.x, -this.y, -this.z);
    }

    public Location setX(double x) {
        return new Location(x, this.y, this.z);
    }

    public Location setY(double y) {
        return new Location(this.x, y, this.z);
    }

    public Location setZ(double z) {
        return new Location(this.x, this.y, z);
    }

    public Location addX(double x) {
        return new Location(this.x + x, this.y, this.z);
    }

    public Location addY(double y) {
        return new Location(this.x, this.y + y, this.z);
    }

    public Location addZ(double z) {
        return new Location(this.x, this.y, this.z + z);
    }

    public Location scaleX(double x) {
        return new Location(this.x * x, this.y, this.z);
    }

    public Location scaleY(double y) {
        return new Location(this.x, this.y * y, this.z);
    }

    public Location scaleZ(double z) {
        return new Location(this.x, this.y, this.z * z);
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "[%.2f; %.2f; %.2f]", this.x, this.y, this.z);
    }

    static {
        PropertyEditorManager.registerEditor(Location.class, PropertyEditor.class);
        locationPattern = Pattern.compile("\\[([-+]?[0-9]+(\\.[0-9]+){0,1})\\;[ ]?([-+]?[0-9]+(\\.[0-9]+){0,1})\\;[ ]?([-+]?[0-9]+(\\.[0-9]+){0,1})\\]");
    }

    public static class PropertyEditor
    extends PropertyEditorSupport {
        @Override
        public String getAsText() {
            if (this.getValue() != null) {
                return this.getValue().toString();
            }
            return "null";
        }

        @Override
        public void setAsText(String s) {
            if ("null".equals(s.trim())) {
                this.setValue(null);
            } else {
                double[] d = PropertyEditor.parseNumberArray(s);
                if (d.length != 3) {
                    throw new IllegalArgumentException();
                }
                this.setValue(new Location(d));
            }
        }

        public static double[] parseNumberArray(String s) {
            if ((s = s.trim()).startsWith("[") && s.endsWith("]") || s.startsWith("(") && s.endsWith(")")) {
                s = s.substring(1, s.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(s, ";");
            try {
                double[] d = new double[st.countTokens()];
                for (int i = 0; i < d.length; ++i) {
                    d[i] = Double.parseDouble(st.nextToken());
                }
                return d;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }
    }
}

