/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.math;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DistanceUtils {
    public static final RelationCloser relationCloser = new RelationCloser();
    public static final RelationFurther relationFurther = new RelationFurther();
    public static final GetLocatedDistance3D<ILocated> getLocatedDistance3D = new GetLocatedDistance3D();
    public static final GetLocatedDistance2D<ILocated> getLocatedDistance2D = new GetLocatedDistance2D();
    public static final AcceptAllDistanceFilter acceptAllDistanceFilter = new AcceptAllDistanceFilter();
    public static final IDistanceFilter[] NO_FILTER = new IDistanceFilter[]{acceptAllDistanceFilter};
    public static final VisibleFilter<IViewable> visibleFilter = new VisibleFilter();
    private static final DistancesComparator distancesComparator = new DistancesComparator();

    public static <T> T getInBestRelation(Collection<T> locations, ILocated target, IGetDistance getDistance, IBetterRelation betterRelation, IDistanceFilter ... filters) {
        if (filters == null || filters.length == 1 && filters[0] == acceptAllDistanceFilter) {
            return DistanceUtils.getInBestRelation(locations, target, getDistance, betterRelation);
        }
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        if (betterRelation == null) {
            return null;
        }
        Object bestCandidate = null;
        double bestCandidateDistance = betterRelation.getWorstValue();
        for (T location : locations) {
            double distance = getDistance.getDistance(location, target);
            boolean accepted = true;
            for (IDistanceFilter filter : filters) {
                if (filter == null || filter.isAccepted(location, target, distance)) continue;
                accepted = false;
                break;
            }
            if (!accepted || !betterRelation.isBetterRelation(target, location, distance, bestCandidate, bestCandidateDistance)) continue;
            bestCandidateDistance = distance;
            bestCandidate = location;
        }
        return bestCandidate;
    }

    public static <T> T getInBestRelation(Collection<T> locations, ILocated target, IGetDistance getDistance, IBetterRelation betterRelation) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        if (betterRelation == null) {
            return null;
        }
        Object best = null;
        double bestDistance = betterRelation.getWorstValue();
        for (T location : locations) {
            double distance;
            if (!betterRelation.isBetterRelation(target, location, distance = getDistance.getDistance(location, target), best, bestDistance)) continue;
            bestDistance = distance;
            best = location;
        }
        return best;
    }

    public static <T> T getInNthBestRelation(int nthBest, Collection<T> locations, ILocated target, IGetDistance getDistance, IBetterRelation betterRelation, IDistanceFilter ... filters) {
        if (nthBest < 1) {
            return DistanceUtils.getInBestRelation(locations, target, getDistance, betterRelation, filters);
        }
        if (filters == null) {
            return null;
        }
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        if (betterRelation == null) {
            return null;
        }
        ArrayList<Tuple2> best = new ArrayList<Tuple2>();
        for (T location : locations) {
            Tuple2 candidate;
            int i;
            double distance = getDistance.getDistance(location, target);
            boolean accepted = true;
            for (IDistanceFilter filter : filters) {
                if (filter == null || filter.isAccepted(location, target, distance)) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            for (i = 0; i < best.size() && !betterRelation.isBetterRelation(target, location, distance, (candidate = (Tuple2)best.get(i)).getFirst(), (Double)candidate.getSecond()); ++i) {
            }
            if (i >= nthBest) continue;
            if (i < best.size()) {
                best.add(i, new Tuple2(location, (Object)distance));
                continue;
            }
            best.add(new Tuple2(location, (Object)distance));
        }
        return (T)(best.size() == 0 ? null : ((Tuple2)best.get(best.size() - 1)).getFirst());
    }

    public static <T> T getInNthBestRelation(int nthBest, Collection<T> locations, ILocated target, IGetDistance getDistance, IBetterRelation betterRelation) {
        if (nthBest < 1) {
            return DistanceUtils.getInBestRelation(locations, target, getDistance, betterRelation);
        }
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        if (betterRelation == null) {
            return null;
        }
        ArrayList<Tuple2> best = new ArrayList<Tuple2>();
        for (T location : locations) {
            Tuple2 candidate;
            int i;
            double distance = getDistance.getDistance(location, target);
            for (i = 0; i < best.size() && !betterRelation.isBetterRelation(target, location, distance, (candidate = (Tuple2)best.get(i)).getFirst(), (Double)candidate.getSecond()); ++i) {
            }
            if (i >= nthBest) continue;
            if (i < best.size()) {
                best.add(i, new Tuple2(location, (Object)distance));
                continue;
            }
            best.add(new Tuple2(location, (Object)distance));
        }
        return (T)(best.size() == 0 ? null : ((Tuple2)best.get(best.size() - 1)).getFirst());
    }

    public static <T> T getNearest(Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        return DistanceUtils.getInBestRelation(locations, target, getDistance, relationCloser, filters);
    }

    public static <T> T getNthNearest(int nthNearest, Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        return DistanceUtils.getInNthBestRelation(nthNearest, locations, target, getDistance, relationCloser, filters);
    }

    public static <T> T getFarthest(Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        return DistanceUtils.getInBestRelation(locations, target, getDistance, relationFurther, filters);
    }

    public static <T> T getNthFarthest(int nthFarthest, Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        return DistanceUtils.getInNthBestRelation(nthFarthest, locations, target, getDistance, relationFurther, filters);
    }

    public static <T> T getNearest(Collection<T> locations, ILocated target, IGetDistance getDistance) {
        return DistanceUtils.getInBestRelation(locations, target, getDistance, relationCloser);
    }

    public static <T> T getNthNearest(int nthNearest, Collection<T> locations, ILocated target, IGetDistance getDistance) {
        return DistanceUtils.getInNthBestRelation(nthNearest, locations, target, getDistance, relationCloser);
    }

    public static <T> T getFarthest(Collection<T> locations, ILocated target, IGetDistance getDistance) {
        return DistanceUtils.getInBestRelation(locations, target, getDistance, relationFurther);
    }

    public static <T> T getNthFarthest(int nthFarthest, Collection<T> locations, ILocated target, IGetDistance getDistance) {
        return DistanceUtils.getInNthBestRelation(nthFarthest, locations, target, getDistance, relationFurther);
    }

    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance3D, filters));
    }

    public static <T extends ILocated> T getNthNearest(int nthNearest, Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNthNearest(nthNearest, locations, target, getLocatedDistance3D, filters));
    }

    public static <T extends ILocated> T getFarthest(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getFarthest(locations, target, getLocatedDistance3D, filters));
    }

    public static <T extends ILocated> T getNthFarthest(int nthFarthest, Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNthFarthest(nthFarthest, locations, target, getLocatedDistance3D, filters));
    }

    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance3D));
    }

    public static <T extends ILocated> T getNthNearest(int nthNearest, Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNthNearest(nthNearest, locations, target, getLocatedDistance3D));
    }

    public static <T extends ILocated> T getFarthest(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getFarthest(locations, target, getLocatedDistance3D));
    }

    public static <T extends ILocated> T getNthFarthest(int nthFarthest, Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNthFarthest(nthFarthest, locations, target, getLocatedDistance3D));
    }

    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNearest(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getNthNearest(int nthNearest, Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNthNearest(nthNearest, locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getFarthest(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getFarthest(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getNthFarthest(int nthFarthest, Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNthFarthest(nthFarthest, locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getNearestFiltered(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getNearest(locations, target);
        }
        return DistanceUtils.getNearest(locations, target, new FilterAdapter(filter));
    }

    public static <T extends ILocated> T getNthNearestFiltered(int nthNearest, Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getNthNearest(nthNearest, locations, target);
        }
        return DistanceUtils.getNthNearest(nthNearest, locations, target, new FilterAdapter(filter));
    }

    public static <T extends ILocated> T getFarthestFiltered(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getFarthest(locations, target);
        }
        return DistanceUtils.getFarthest(locations, target, new FilterAdapter(filter));
    }

    public static <T extends ILocated> T getNthFarthestFiltered(int nthFarthest, Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getNthFarthest(nthFarthest, locations, target);
        }
        return DistanceUtils.getNthFarthest(nthFarthest, locations, target, new FilterAdapter(filter));
    }

    public static <T extends IViewable> T getNearestVisible(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNearest(locations, target, getLocatedDistance3D, visibleFilter));
    }

    public static <T extends IViewable> T getNthNearestVisible(int nthNearest, Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNthNearest(nthNearest, locations, target, getLocatedDistance3D, visibleFilter));
    }

    public static <T extends IViewable> T getFarthestVisible(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getFarthest(locations, target, getLocatedDistance3D, visibleFilter));
    }

    public static <T extends IViewable> T getNthFarthestVisible(int nthFarthest, Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNthFarthest(nthFarthest, locations, target, getLocatedDistance3D, visibleFilter));
    }

    public static <T> List<T> getDistanceSorted(Collection<T> locations, ILocated target, IGetDistance getDistance) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        ArrayList<Tuple2> distances = new ArrayList<Tuple2>(locations.size());
        for (T location : locations) {
            double distance = getDistance.getDistance(location, target);
            distances.add(new Tuple2(location, (Object)distance));
        }
        Collections.sort(distances, distancesComparator);
        ArrayList<Object> result = new ArrayList<Object>(distances.size());
        for (Tuple2 location : distances) {
            result.add(location.getFirst());
        }
        return result;
    }

    public static <T> List<T> getDistanceSorted(Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        if (filters == null || filters.length == 0 || filters.length == 1 && filters[0] instanceof AcceptAllDistanceFilter) {
            return DistanceUtils.getDistanceSorted(locations, target, getDistance);
        }
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        ArrayList<Tuple2> distances = new ArrayList<Tuple2>(locations.size());
        for (T location : locations) {
            boolean accepted = true;
            double distance = getDistance.getDistance(location, targetLoc);
            for (IDistanceFilter filter : filters) {
                if (filter.isAccepted(location, targetLoc, distance)) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            distances.add(new Tuple2(location, (Object)distance));
        }
        Collections.sort(distances, distancesComparator);
        ArrayList<Object> result = new ArrayList<Object>(distances.size());
        for (Tuple2 location : distances) {
            result.add(location.getFirst());
        }
        return result;
    }

    public static <T extends ILocated> List<T> getDistanceSorted(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return DistanceUtils.getDistanceSorted(locations, target, getLocatedDistance3D, filters);
    }

    public static <T extends ILocated> List<T> getDistanceSorted(Collection<T> locations, ILocated target) {
        return DistanceUtils.getDistanceSorted(locations, target, getLocatedDistance3D);
    }

    public static <T extends ILocated> List<T> getDistanceSorted(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getDistanceSorted(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> List<T> getDistanceSortedFiltered(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getDistanceSorted(locations, target);
        }
        return DistanceUtils.getDistanceSorted(locations, target, new FilterAdapter(filter));
    }

    public static <T extends IViewable> List<T> getDistanceSortedVisible(Collection<T> locations, ILocated target) {
        return DistanceUtils.getDistanceSorted(locations, target, getLocatedDistance3D, visibleFilter);
    }

    @Deprecated
    public static <T> T getSecondNearest(Collection<T> locations, ILocated target, IGetDistance getDistance) {
        return DistanceUtils.getNthNearest(2, locations, target, getDistance);
    }

    @Deprecated
    public static <T> T getSecondNearest(Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        return DistanceUtils.getNthNearest(2, locations, target, getDistance, filters);
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return DistanceUtils.getNthNearest(2, locations, target, filters);
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target) {
        return DistanceUtils.getNthNearest(2, locations, target);
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNthNearest(2, locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearestFiltered(Collection<T> locations, ILocated target, IFilter filter) {
        return DistanceUtils.getNthNearestFiltered(2, locations, target, filter);
    }

    @Deprecated
    public static <T extends IViewable> T getSecondNearestVisible(Collection<T> locations, ILocated target) {
        return DistanceUtils.getNthNearestVisible(2, locations, target);
    }

    public static <T extends ILocated> T getNearest2D(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance2D, filters));
    }

    public static <T extends ILocated> T getNthNearest2D(int nthNearest, Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNthNearest(nthNearest, locations, target, getLocatedDistance2D, filters));
    }

    public static <T extends ILocated> T getFarthest2D(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getFarthest(locations, target, getLocatedDistance2D, filters));
    }

    public static <T extends ILocated> T getNthFarthest2D(int nthFarthest, Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNthFarthest(nthFarthest, locations, target, getLocatedDistance2D, filters));
    }

    public static <T extends ILocated> T getNearest2D(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance2D));
    }

    public static <T extends ILocated> T getNthNearest2D(int nthNearest, Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNthNearest(nthNearest, locations, target, getLocatedDistance2D));
    }

    public static <T extends ILocated> T getFarthest2D(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getFarthest(locations, target, getLocatedDistance2D));
    }

    public static <T extends ILocated> T getNthFarthest2D(int nthFarthest, Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNthFarthest(nthFarthest, locations, target, getLocatedDistance2D));
    }

    public static <T extends ILocated> T getNearest2D(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNearest2D(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getNthNearest2D(int nthNearest, Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNthNearest2D(nthNearest, locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getFarthest2D(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getFarthest2D(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getNthFarthest2D(int nthFarthest, Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNthFarthest2D(nthFarthest, locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getNearestFiltered2D(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getNearest2D(locations, target);
        }
        return DistanceUtils.getNearest2D(locations, target, new FilterAdapter(filter));
    }

    public static <T extends ILocated> T getNthNearestFiltered2D(int nthNearest, Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getNthNearest2D(nthNearest, locations, target);
        }
        return DistanceUtils.getNthNearest2D(nthNearest, locations, target, new FilterAdapter(filter));
    }

    public static <T extends ILocated> T getFarthestFiltered2D(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getFarthest2D(locations, target);
        }
        return DistanceUtils.getFarthest2D(locations, target, new FilterAdapter(filter));
    }

    public static <T extends ILocated> T getNthFarthestFiltered2D(int nthFarthest, Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getNthFarthest2D(nthFarthest, locations, target);
        }
        return DistanceUtils.getNthFarthest2D(nthFarthest, locations, target, new FilterAdapter(filter));
    }

    public static <T extends IViewable> T getNearestVisible2D(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNearest(locations, target, getLocatedDistance2D, visibleFilter));
    }

    public static <T extends IViewable> T getNthNearestVisible2D(int nthNearest, Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNthNearest(nthNearest, locations, target, getLocatedDistance2D, visibleFilter));
    }

    public static <T extends IViewable> T getFarthestVisible2D(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getFarthest(locations, target, getLocatedDistance2D, visibleFilter));
    }

    public static <T extends IViewable> T getNthFarthestVisible2D(int nthFarthest, Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNthFarthest(nthFarthest, locations, target, getLocatedDistance2D, visibleFilter));
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearest2D(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return DistanceUtils.getNthNearest2D(2, locations, target, filters);
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearest2D(Collection<T> locations, ILocated target) {
        return DistanceUtils.getNthNearest2D(2, locations, target);
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearest2D(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNthNearest2D(2, locations, target, maxDistance);
    }

    @Deprecated
    public static <T extends ILocated> T getSecondNearest2DFiltered(Collection<T> locations, ILocated target, IFilter<T> filter) {
        if (filter == null) {
            return DistanceUtils.getNthNearest2D(2, locations, target);
        }
        return DistanceUtils.getNthNearest2D(2, locations, target, new FilterAdapter<T>(filter));
    }

    @Deprecated
    public static <T extends IViewable> T getSecondNearest2DVisible(Collection<T> locations, ILocated target) {
        return DistanceUtils.getNthNearestVisible2D(2, locations, target);
    }

    private static class DistancesComparator
    implements Comparator<Tuple2<Object, Double>> {
        private DistancesComparator() {
        }

        @Override
        public int compare(Tuple2<Object, Double> o1, Tuple2<Object, Double> o2) {
            double result = (Double)o1.getSecond() - (Double)o2.getSecond();
            if (result < 0.0) {
                return -1;
            }
            if (result > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    public static class FilterAdapter<T>
    implements IDistanceFilter<T> {
        private IFilter<T> filter;

        public FilterAdapter(IFilter<T> filter) {
            this.filter = filter;
        }

        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return this.filter.isAccepted(object);
        }
    }

    public static class VisibleFilter<T extends IViewable>
    implements IDistanceFilter<T> {
        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return object.isVisible();
        }
    }

    public static class RangeDistanceFilter<T>
    implements IDistanceFilter<T> {
        private double minDistance;
        private double maxDistance;

        public RangeDistanceFilter(double minDistance, double maxDistance) {
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return this.minDistance <= distanceToTarget && distanceToTarget <= this.maxDistance;
        }
    }

    public static final class AcceptAllDistanceFilter<T>
    implements IDistanceFilter<T> {
        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return true;
        }
    }

    public static interface IDistanceFilter<T> {
        public boolean isAccepted(T var1, ILocated var2, double var3);
    }

    public static class GetLocatedDistance2D<T extends ILocated>
    implements IGetDistance<T> {
        @Override
        public double getDistance(T object, ILocated target) {
            if (object.getLocation() == null) {
                return Double.MAX_VALUE;
            }
            return object.getLocation().getDistance2D(target.getLocation());
        }
    }

    public static class GetLocatedDistance3D<T extends ILocated>
    implements IGetDistance<T> {
        @Override
        public double getDistance(T object, ILocated target) {
            if (object.getLocation() == null) {
                return Double.MAX_VALUE;
            }
            return object.getLocation().getDistance(target.getLocation());
        }
    }

    public static interface IGetDistance<T> {
        public double getDistance(T var1, ILocated var2);
    }

    public static class RelationFurther<T>
    implements IBetterRelation<T> {
        @Override
        public double getWorstValue() {
            return -1.0;
        }

        @Override
        public boolean isBetterRelation(ILocated target, T examinedObject, double examinedObjetToTargetDistance, T currentBestCandidate, double currentBestObjectToTargetDistance) {
            return examinedObjetToTargetDistance > currentBestObjectToTargetDistance;
        }
    }

    public static class RelationCloser<T>
    implements IBetterRelation<T> {
        @Override
        public double getWorstValue() {
            return Double.MAX_VALUE;
        }

        @Override
        public boolean isBetterRelation(ILocated target, T examinedObject, double examinedObjetToTargetDistance, T currentBestCandidate, double currentBestObjectToTargetDistance) {
            return examinedObjetToTargetDistance < currentBestObjectToTargetDistance;
        }
    }

    public static interface IBetterRelation<T> {
        public double getWorstValue();

        public boolean isBetterRelation(ILocated var1, T var2, double var3, T var5, double var6);
    }
}

