package cz.cuni.amis.pogamut.defcon.utils.tests;

import java.util.Collection;
import java.util.LinkedList;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.utils.PolygonUtils;

@RunWith(value = Parameterized.class)
public class PolygonResizeTest {
	
	LinkedList<Location> data;
	double offset;
	
    @Parameters
    public static Collection<Object[]> data() {
    	LinkedList<Object[]> data = new LinkedList<Object[]>();
    	
    	LinkedList<Location> datum;
    	
    	// 1
    	
    	datum = new LinkedList<Location>();
    	
    	datum.add(new Location(0,0));
    	datum.add(new Location(2,0));
    	datum.add(new Location(2,2));
    	datum.add(new Location(0,2));
    	
    	data.add(new Object[] { datum, -1d }); 
    	
    	// 2
    	
    	datum = new LinkedList<Location>();
    	
    	datum.add(new Location(0,0));
    	datum.add(new Location(0,2));
    	datum.add(new Location(2,2));
    	datum.add(new Location(2,0));    	    	
    	
    	data.add(new Object[] { datum, -1d });
    	
   	
    	
    	return data;
    }
    
    public PolygonResizeTest(LinkedList<Location> data, double offset) {
    	this.data = data;
    	this.offset = offset;
    }
	
	@Test
	public void testPoly() {
		LinkedList<Location> output = PolygonUtils.resizePoly2(data, offset);
		
		System.out.println(output);
	}
}
