/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLFolder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLLogRecorder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLProperty;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import java.awt.Color;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;

public abstract class TLEntity
implements Serializable {
    private State entityState = State.RECORDING;
    private Long startTime;
    private Long endTime;
    protected TLDatabase database;
    private String name;
    private Color color = Color.BLACK;
    private TreeSet<TLLogRecorder> logRecorders = new TreeSet();
    protected TLFolder storageFolder;
    private transient HashSet<Listener> listeners;

    protected Listener[] getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        return this.listeners.toArray(new Listener[this.listeners.size()]);
    }

    public void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.remove(listener);
    }

    protected TLEntity(TLDatabase database, long timestamp) {
        this.database = database;
        this.startTime = timestamp;
        this.endTime = timestamp;
    }

    public long getStartTime() {
        assert (this.startTime != null);
        return this.startTime;
    }

    public long getEndTime() {
        assert (this.endTime != null);
        return this.endTime;
    }

    protected void setEndTime(long newEnd) {
        if (this.entityState != State.RECORDING) {
            return;
        }
        if (newEnd > this.endTime) {
            long previousEndTime = this.endTime;
            this.endTime = newEnd;
            for (Listener listener : this.getListeners()) {
                listener.endTimeChanged(this, previousEndTime, this.endTime);
            }
        }
    }

    public void finish() {
        if (this.entityState != State.FINISHED) {
            this.entityState = State.FINISHED;
            for (TLLogRecorder logRecorder : this.logRecorders) {
                logRecorder.stopRecording(this.getEndTime());
            }
            this.database.emitEntityLeft(this);
        }
    }

    public TLDatabase getDatabase() {
        return this.database;
    }

    public abstract String getDisplayName();

    public synchronized void addLogRecording(Logger logger) {
        if (this.entityState != State.RECORDING) {
            return;
        }
        TLLogRecorder logRecorder = new TLLogRecorder(logger, this);
        this.logRecorders.add(logRecorder);
    }

    public Set<TLLogRecorder> getLogRecorders() {
        return Collections.unmodifiableSet(this.logRecorders);
    }

    public State getState() {
        return this.entityState;
    }

    protected Double getDoublePropertyValue(TLFolder folder, String propName, long time) throws NoSuchFieldException, DataFormatException {
        TLProperty prop = folder.findProperty(propName);
        if (prop == null) {
            throw new NoSuchFieldException("Property " + propName + " not found in folder " + folder.getName() + " in entity " + this.getDisplayName() + ", type " + this.getClass().getSimpleName());
        }
        Object value = prop.getValue(time);
        if (value == null) {
            throw new DataFormatException("No value stored in property " + propName + ", folder " + folder.getName() + " in entity " + this.getDisplayName() + ", type " + this.getClass().getSimpleName());
        }
        if (prop.getType() != Double.TYPE && prop.getType() != Double.class) {
            throw new DataFormatException("Property " + propName + " is not double class in folder " + folder.getName() + ", but " + value.getClass() + " in entity " + this.getDisplayName() + ", type " + this.getClass().getSimpleName());
        }
        return (Double)value;
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public abstract Location getLocation(long var1);

    public abstract Rotation getRotation(long var1);

    public abstract Velocity getVelocity(long var1);

    public TLFolder getFolder() {
        return this.storageFolder;
    }

    public void printInfo(PrintStream stream) {
        stream.println("Entity " + this.getDisplayName() + " (LR: " + this.getLogRecorders().size() + ")");
        for (TLLogRecorder logRec : this.getLogRecorders()) {
            logRec.printInfo(stream);
        }
        stream.println();
    }

    public static interface Listener {
        public void endTimeChanged(TLEntity var1, long var2, long var4);

        public void logRecorderAdded(TLEntity var1, TLLogRecorder var2);
    }

    public static class Adapter
    implements Listener {
        @Override
        public void endTimeChanged(TLEntity entity, long previousEndTime, long endTime) {
        }

        @Override
        public void logRecorderAdded(TLEntity entity, TLLogRecorder recorder) {
        }
    }

    public static enum State {
        INSTANTIATED,
        RECORDING,
        FINISHED;

    }
}

