/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogEvent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogEvents;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogMessage;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.MapEvent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.MapEvents;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.view.TLTools;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class TLLogRecorder
implements Comparable,
Serializable {
    private transient Logger logger;
    private TLEntity entity;
    private transient HashSet<TLLogRecorderListener> listeners = new HashSet();
    private String name;
    private LogEvents logEvents;
    private MapEvents mapEvents;
    private transient Handler handler = new Handler(){

        @Override
        public void publish(final LogRecord record) {
            TLTools.runAndWaitInAWTThread(new Runnable(){

                @Override
                public void run() {
                    TLLogRecorder.this.addRecord(record);
                }
            });
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };

    TLLogRecorder(Logger logger, TLEntity entity) {
        this.entity = entity;
        this.logger = logger;
        this.mapEvents = new MapEvents(entity);
        this.logEvents = new LogEvents();
        this.name = logger.getName();
        this.logger.addHandler(this.handler);
    }

    public List<MapEvent> getMapEvents(long time) {
        return this.mapEvents.getEvents(time);
    }

    public String getName() {
        return this.name;
    }

    public TLEntity getEntity() {
        return this.entity;
    }

    public Logger getSourceLogger() {
        return this.logger;
    }

    protected void addRecord(LogRecord record) {
        LogEvent logEvent;
        LogMessage logMessage = this.logEvents.updateLogMessages(record);
        if (logMessage != null) {
            this.emitNewLogMessage(logMessage);
        }
        if ((logEvent = this.logEvents.updateLogEvents(record)) != null) {
            this.emitNewLogEvent(logEvent);
        }
        this.mapEvents.update(record);
        long milis = record.getMillis();
        this.entity.setEndTime(milis);
    }

    void stopRecording(long timestamp) {
        if (this.logger != null) {
            this.logger.removeHandler(this.handler);
        }
    }

    protected HashSet<TLLogRecorderListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        return this.listeners;
    }

    private void emitNewLogEvent(LogEvent newEvent) {
        TLLogRecorderListener[] listenersArray;
        for (TLLogRecorderListener listener : listenersArray = this.getListeners().toArray(new TLLogRecorderListener[0])) {
            listener.onNewLogEvent(newEvent);
        }
    }

    private void emitNewLogMessage(LogMessage newMessage) {
        TLLogRecorderListener[] listenersArray;
        for (TLLogRecorderListener listener : listenersArray = this.getListeners().toArray(new TLLogRecorderListener[0])) {
            listener.onNewLogMessage(newMessage);
        }
    }

    public void addLogRecordListener(TLLogRecorderListener listener) {
        this.getListeners().add(listener);
    }

    public void removeLogRecordListener(TLLogRecorderListener listener) {
        this.getListeners().remove(listener);
    }

    public int compareTo(Object o) {
        TLLogRecorder other = (TLLogRecorder)o;
        return this.getSourceLogger().getName().compareTo(other.getSourceLogger().getName());
    }

    public void printInfo(PrintStream stream) {
        stream.println("LogRecorder " + this.getName());
        for (LogMessage lMessage : this.logEvents.getMessages()) {
            stream.println(" * LM: " + lMessage.getMessage());
        }
        for (LogEvent lEvent : this.logEvents.getEvents()) {
            stream.println(" * LE: " + lEvent.getMessage());
        }
        for (MapEvent mEvent : this.mapEvents.getMapEvents()) {
            stream.println(" * " + mEvent.getMessage());
        }
        stream.println();
    }

    public MapEvents getMapEvents() {
        return this.mapEvents;
    }

    public LogEvents getLogEvents() {
        return this.logEvents;
    }

    public static interface TLLogRecorderListener {
        public void onNewLogEvent(LogEvent var1);

        public void onNewLogMessage(LogMessage var1);
    }
}

