/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.pogamut.base.utils.logging.marks.LogEventMark;
import java.io.Serializable;
import java.util.logging.LogRecord;
import java.util.zip.DataFormatException;

public class LogEvent
implements Serializable {
    private LogRecord record;
    private LogRecord closingRecord;
    private LogEventMark mark;
    private int slot;

    LogEvent(LogRecord record, int slot) throws DataFormatException {
        this.record = record;
        this.slot = slot;
        for (Object parameter : record.getParameters()) {
            if (!(parameter instanceof LogEventMark)) continue;
            this.mark = (LogEventMark)parameter;
            return;
        }
        throw new DataFormatException("LogRecord " + record.toString() + " doesn't have a log duration mark.");
    }

    LogEvent(LogRecord record, LogEventMark mark, int slot) {
        this.record = record;
        this.mark = mark;
        this.slot = slot;
    }

    public LogEventMark getMark() {
        return this.mark;
    }

    public String getMessage() {
        return this.mark.getText();
    }

    public int getSlot() {
        return this.slot;
    }

    public long getStartTS() {
        return this.mark.getTime();
    }

    public long getDuration() {
        if (this.mark.getType() == LogEventMark.Type.START_EVENT) {
            if (this.closingRecord == null) {
                return this.mark.getDuration();
            }
            return this.closingRecord.getMillis() - this.mark.getTime();
        }
        return this.mark.getDuration();
    }

    public long getEndTS() {
        return this.getStartTS() + this.getDuration() - 1L;
    }

    void revievedClosingRecord(LogRecord closingRecord) {
        this.closingRecord = closingRecord;
    }
}

