/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IFadeLine;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IRenderableUTAgent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.TLFadeLine;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.MapEvent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLLogRecorder;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

class TLRenderableUTAgent
implements IRenderableUTAgent {
    private TLEntity entity;
    private long time;
    private IFadeLine fadeLine;
    private int glName;

    TLRenderableUTAgent(TLEntity entity, long time, int glName) {
        this.entity = entity;
        this.time = time;
        this.fadeLine = new TLFadeLine(entity, time);
        this.glName = glName;
    }

    public Location getLocation() {
        return this.entity.getLocation(this.time);
    }

    public Rotation getRotation() {
        return this.entity.getRotation(this.time);
    }

    public Velocity getVelocity() {
        return this.entity.getVelocity(this.time);
    }

    @Override
    public Color getColor() {
        return this.entity.getColor();
    }

    @Override
    public IFadeLine getFadeLine() {
        return this.fadeLine;
    }

    @Override
    public List<String> getAssociatedInfo() {
        LinkedList<String> entityEvents = new LinkedList<String>();
        for (TLLogRecorder recorder : this.entity.getLogRecorders()) {
            List<MapEvent> mapEvents = recorder.getMapEvents(this.time);
            for (MapEvent mapEvent : mapEvents) {
                if (!mapEvent.shouldFollowPlayer()) continue;
                entityEvents.add(mapEvent.getMessage());
            }
        }
        return entityEvents;
    }

    @Override
    public List<MapEvent> getMapEvents() {
        LinkedList<MapEvent> mapEvents = new LinkedList<MapEvent>();
        for (TLLogRecorder recorder : this.entity.getLogRecorders()) {
            mapEvents.addAll(recorder.getMapEvents().getEvents(this.time));
        }
        return mapEvents;
    }

    public void respawn() throws PogamutException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IAct getAct() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getName() {
        return this.entity.getDisplayName();
    }

    public AgentLogger getLogger() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ImmutableFlag<IAgentState> getState() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void start() throws AgentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void pause() throws AgentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resume() throws AgentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void stop() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void kill() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Folder getIntrospection() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TLEntity getDataSource() {
        return this.entity;
    }

    @Override
    public int getGLName() {
        return this.glName;
    }

    public IWorldView getWorldView() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IAgentId getComponentId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IComponentBus getEventBus() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void startPaused() throws ComponentCantStartException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

