/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.map;

import cz.cuni.amis.nb.api.pogamut.base.server.ServerDefinition;
import cz.cuni.amis.nb.pogamut.unreal.map.PureMapGLPanel;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.net.URI;
import javax.swing.SwingUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

public class PureMapTopComponent
extends TopComponent
implements FlagListener<IUnrealServer> {
    protected ServerDefinition<IUnrealServer> serverDef;
    protected PureMapGLPanel mapPanel;
    protected InstanceContent lookupContent;

    public PureMapTopComponent(ServerDefinition<IUnrealServer> serverDef) {
        this.serverDef = serverDef;
        this.setUpMapPanel();
        this.lookupContent = new InstanceContent();
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.lookupContent));
        this.handleServerName();
        serverDef.getServerFlag().addListener((FlagListener)this);
    }

    protected void handleServerName() {
        this.setPanelName();
        this.serverDef.getServerNameFlag().addListener((FlagListener)new FlagListener<String>(){

            public void flagChanged(String changedValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PureMapTopComponent.this.setPanelName();
                    }
                });
            }
        });
    }

    protected void setPanelName() {
        String map = "no map";
        if (this.serverDef.getServerFlag().getFlag() != null) {
            map = ((IUnrealServer)this.serverDef.getServerFlag().getFlag()).getMapName();
        }
        this.setDisplayName(this.serverDef.getServerName() + " [" + map + "]");
    }

    protected void setUpMapPanel() {
        IUnrealServer server = (IUnrealServer)this.serverDef.getServerFlag().getFlag();
        this.mapPanel = new PureMapGLPanel(server.getMap(), server);
        if (this.isOpened()) {
            this.mapPanel.startDisplayLoop();
        }
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.mapPanel), "Center");
    }

    public void flagChanged(IUnrealServer server) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PureMapTopComponent.this.removeAll();
                PureMapTopComponent.this.handleServerName();
                if (PureMapTopComponent.this.serverDef.getServerFlag().getFlag() == null) {
                    PureMapTopComponent.this.add(new Label("Server not available ...", 1), "Center");
                } else {
                    PureMapTopComponent.this.setUpMapPanel();
                }
                PureMapTopComponent.this.revalidate();
                PureMapTopComponent.this.repaint();
            }
        });
    }

    protected String preferredID() {
        URI uri = this.serverDef.getUri();
        return "PureMapTC_" + uri.getHost() + ":" + uri.getPort();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentOpened() {
        this.mapPanel.startDisplayLoop();
        super.componentOpened();
    }

    protected void componentClosed() {
        this.mapPanel.stopDisplayLoop();
        super.componentClosed();
    }
}

