/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline;

import cz.cuni.amis.nb.pogamut.base.NamedAction;
import cz.cuni.amis.nb.pogamut.unreal.timeline.TLEntityNode;
import cz.cuni.amis.nb.pogamut.unreal.timeline.dataobject.TLDataObject;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLAgentEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.view.TLTools;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.nb.util.collections.ObservableCollectionNode;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.unreal.bot.IUnrealBot;
import cz.cuni.amis.pogamut.unreal.bot.impl.NativeUnrealBotAdapter;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.collections.CollectionEventListener;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableList;
import cz.cuni.amis.utils.exception.PogamutException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class UTTimelineNode
extends ObservableCollectionNode<TLEntity> {
    private TLDataObject dataObject;
    private IUnrealServer server;
    private DBAgentsUpdater agentUpdater;
    private DBAgentsUpdater nativeBotsUpdates;

    public UTTimelineNode(TLDataObject dataObj, IUnrealServer server) {
        super((ObservableCollection)new ObservableList(new LinkedList()), (NodeFactory)new NodeFactory<TLEntity>(){

            public Node[] create(TLEntity entity) {
                TLEntityNode node = new TLEntityNode(entity.getDatabase(), entity);
                return new Node[]{node};
            }
        });
        this.setName(dataObj.getName() + " (" + dataObj.getMapName() + ")");
        this.dataObject = dataObj;
        this.server = server;
        TLDatabase db = this.dataObject.getDatabase();
        this.agentUpdater = new DBAgentsUpdater(db);
        this.nativeBotsUpdates = new DBAgentsUpdater(db);
        db.addDBListener(new UpdateEntityNodes());
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenCookie oc = (OpenCookie)UTTimelineNode.this.dataObject.getLookup().lookup(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                }
            }
        };
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"cz/cuni/amis/nb/pogamut/ut2004/timeline/UTTimelineNodeIcon.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        TLDatabase db = this.dataObject.getDatabase();
        return new Action[]{new StartRecordingAction(db, this.agentUpdater, this.nativeBotsUpdates), new StopRecordingAction(db), new DBSaveAction(this.dataObject)};
    }

    private class DBAgentsUpdater
    implements CollectionEventListener<IUnrealBot> {
        private Logger logger;
        private TLDatabase db;
        private List<TLAgentEntity> addedAgents = new LinkedList<TLAgentEntity>();

        public DBAgentsUpdater(TLDatabase db) {
            this.db = db;
            this.logger = Logger.getLogger("DBAgentUpdater");
            this.logger.setLevel(Level.OFF);
        }

        public void preAddEvent(Collection<IUnrealBot> toBeAdded, Collection<IUnrealBot> whereToAdd) {
        }

        public void postAddEvent(Collection<IUnrealBot> alreadyAdded, Collection<IUnrealBot> whereWereAdded) {
            for (IUnrealBot agent : alreadyAdded) {
                this.reflectAddedAgent(agent);
            }
        }

        protected void reflectAddedAgent(IUnrealBot newAgent) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Reflect added agent " + newAgent + " " + newAgent.getName() + " in " + this);
            }
            final TLAgentEntity agentEntity = new TLAgentEntity(this.db, newAgent);
            TLTools.runAndWaitInAWTThread(new Runnable(){

                @Override
                public void run() {
                    DBAgentsUpdater.this.addedAgents.add(agentEntity);
                    DBAgentsUpdater.this.db.entityEntered(agentEntity);
                }
            });
        }

        public void preRemoveEvent(Collection<IUnrealBot> toBeRemoved, Collection<IUnrealBot> whereToRemove) {
            for (IAgent iAgent : toBeRemoved) {
                this.reflectRemovedAgent(iAgent);
            }
        }

        public void postRemoveEvent(Collection<IUnrealBot> alreadyAdded, Collection<IUnrealBot> whereWereRemoved) {
        }

        protected void reflectRemovedAgent(IAgent removedAgent) {
            TLAgentEntity[] agentEntities;
            for (final TLAgentEntity agentEntity : agentEntities = this.addedAgents.toArray(new TLAgentEntity[0])) {
                if (agentEntity.getAgent() != removedAgent) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Found added agent in array, agent is leaving");
                }
                TLTools.runAndWaitInAWTThread(new Runnable(){

                    @Override
                    public void run() {
                        agentEntity.finish();
                    }
                });
                this.addedAgents.remove(agentEntity);
            }
        }
    }

    private class StopRecordingAction
    extends NamedAction {
        private TLDatabase db;

        public StopRecordingAction(TLDatabase db) {
            super("ACT_TLStopRecording");
            this.db = db;
        }

        protected void action(ActionEvent e) throws PogamutException {
            this.db.stopRecording();
            ObservableCollection agents = UTTimelineNode.this.server.getAgents();
            ObservableCollection nativeBots = UTTimelineNode.this.server.getNativeAgents();
            agents.removeCollectionListener((CollectionEventListener)UTTimelineNode.this.agentUpdater);
            nativeBots.removeCollectionListener((CollectionEventListener)UTTimelineNode.this.nativeBotsUpdates);
        }
    }

    private class StartRecordingAction
    extends NamedAction {
        private TLDatabase db;
        private DBAgentsUpdater agentUpdater;
        private DBAgentsUpdater nativeBotUpdater;

        public StartRecordingAction(TLDatabase db, DBAgentsUpdater agentUpdater, DBAgentsUpdater playerUpdater) {
            super("ACT_TLStartRecording");
            this.db = db;
            this.agentUpdater = agentUpdater;
            this.nativeBotUpdater = playerUpdater;
        }

        protected void action(ActionEvent e) throws PogamutException {
            this.db.startRecording();
            ObservableCollection agents = UTTimelineNode.this.server.getAgents();
            ObservableCollection nativeBots = UTTimelineNode.this.server.getNativeAgents();
            for (IUnrealBot agent : agents) {
                this.agentUpdater.reflectAddedAgent(agent);
            }
            for (NativeUnrealBotAdapter nativeBot : nativeBots) {
                this.nativeBotUpdater.reflectAddedAgent((IUnrealBot)nativeBot);
            }
            agents.addCollectionListener((CollectionEventListener)this.agentUpdater);
            nativeBots.addCollectionListener((CollectionEventListener)UTTimelineNode.this.nativeBotsUpdates);
        }
    }

    private class DBSaveAction
    extends NamedAction {
        private TLDataObject dObj;

        public DBSaveAction(TLDataObject dObj) {
            super("ACT_TLSaveRecording");
            this.dObj = dObj;
        }

        public void action(ActionEvent e) throws PogamutException {
            SaveCookie sc = (SaveCookie)this.dObj.getLookup().lookup(SaveCookie.class);
            if (sc != null) {
                try {
                    sc.save();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private class UpdateEntityNodes
    extends TLDatabase.Adapter {
        Logger logger = Logger.getLogger("UpdateEntityNodes");

        private UpdateEntityNodes() {
        }

        @Override
        public void onEntityEntered(TLDatabase db, TLEntity entity) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("ENTITY ENTERED UT timelinenode  112 " + entity.getDisplayName());
            }
            UTTimelineNode.this.getChildrenCollection().add((Object)entity);
        }

        @Override
        public void onEntityLeft(TLDatabase db, TLEntity entity) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("ENTITYLEFT UT timelinenode  140 " + entity.getDisplayName());
            }
        }
    }
}

