/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.GLTools;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.media.opengl.GL;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class GLTextWindow {
    private GL gl;
    private double borderWidth = 8.0;
    private Texture topLeftCornerTexture;
    private Texture topLineTexture;
    private Texture insideTexture;
    private Rectangle rect;
    private String text = "";
    private TextRenderer textRenderer = new TextRenderer(new Font("SansSerif", 1, 36));

    public GLTextWindow(GL gl, int x, int y, int width, int height) {
        try {
            this.gl = gl;
            this.rect = new Rectangle(x, y, width, height);
            this.loadWindowTextures(gl);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public GLTextWindow(GL gl, int x, int y, int width, int height, String text) {
        this(gl, x, y, width, height);
        this.text = text;
    }

    public synchronized void setText(String text) {
        this.text = text;
    }

    private void loadWindowTextures(GL gl) throws IOException {
        this.topLeftCornerTexture = TextureIO.newTexture((BufferedImage)this.getBufferedImage("cz/cuni/amis/nb/pogamut/ut2004/timeline/map/windowTL.png", 6), (boolean)true);
        this.topLineTexture = TextureIO.newTexture((BufferedImage)this.getBufferedImage("cz/cuni/amis/nb/pogamut/ut2004/timeline/map/windowTop.png", 6), (boolean)true);
        this.insideTexture = TextureIO.newTexture((BufferedImage)this.getBufferedImage("cz/cuni/amis/nb/pogamut/ut2004/timeline/map/windowInside.png", 6), (boolean)true);
    }

    private BufferedImage getBufferedImage(String imageJarPath, int type) {
        Image image = ImageUtilities.loadImage((String)imageJarPath);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, null, null);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        GLTools.pushMatrixMode(this.gl);
        GLTools.setOrthoViewport(this.gl);
        float z = 0.0f;
        this.topLeftCornerTexture.enable();
        this.topLeftCornerTexture.bind();
        this.gl.glBegin(7);
        this.gl.glColor4d(1.0, 1.0, 1.0, 1.0);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x - this.borderWidth, (double)this.rect.y - this.borderWidth, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x, (double)this.rect.y - this.borderWidth, (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x - this.borderWidth, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)this.rect.y - this.borderWidth, (double)z);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width) + this.borderWidth, (double)this.rect.y - this.borderWidth, (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width) + this.borderWidth, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)(this.rect.y + this.rect.height) + this.borderWidth, (double)z);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width) + this.borderWidth, (double)(this.rect.y + this.rect.height) + this.borderWidth, (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width) + this.borderWidth, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x - this.borderWidth, (double)(this.rect.y + this.rect.height) + this.borderWidth, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x, (double)(this.rect.y + this.rect.height) + this.borderWidth, (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x - this.borderWidth, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glEnd();
        this.topLineTexture.bind();
        this.gl.glBegin(7);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x, (double)this.rect.y - this.borderWidth, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)this.rect.y - this.borderWidth, (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width) + this.borderWidth, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width) + this.borderWidth, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)(this.rect.y + this.rect.height) + this.borderWidth, (double)z);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x, (double)(this.rect.y + this.rect.height) + this.borderWidth, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x - this.borderWidth, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x - this.borderWidth, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glEnd();
        this.insideTexture.bind();
        this.gl.glBegin(7);
        this.gl.glTexCoord2d(0.0, 0.0);
        this.gl.glVertex3d((double)this.rect.x, (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(1.0, 0.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)this.rect.y, (double)z);
        this.gl.glTexCoord2d(1.0, 1.0);
        this.gl.glVertex3d((double)(this.rect.x + this.rect.width), (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glTexCoord2d(0.0, 1.0);
        this.gl.glVertex3d((double)this.rect.x, (double)(this.rect.y + this.rect.height), (double)z);
        this.gl.glEnd();
        this.insideTexture.disable();
        GLTextWindow gLTextWindow = this;
        synchronized (gLTextWindow) {
            this.textRenderer.begin3DRendering();
            this.textRenderer.draw3D(this.text, (float)this.rect.x, (float)this.rect.y, z + 0.5f, 1.0f);
            this.textRenderer.end3DRendering();
        }
        GLTools.popMatrixMode(this.gl);
    }

    public void dispose() {
        this.topLeftCornerTexture.dispose();
        this.topLineTexture.dispose();
        this.insideTexture.dispose();
    }
}

