/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.ColorManager;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMapInfo;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.MapInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TLDatabase
implements Serializable {
    private LinkedList<TLEntity> agentsRecords = new LinkedList();
    private Long startTime;
    private Long currentTime;
    private Long endTime;
    private transient ColorManager colorManager = null;
    private IUnrealMap map;
    private transient HashSet<TLDatabaseListener> listeners = new HashSet();

    public long getStartTime() {
        assert (this.startTime != null);
        return this.startTime;
    }

    public long getCurrentTime() {
        assert (this.currentTime != null);
        return this.currentTime;
    }

    public long getEndTime() {
        assert (this.endTime != null);
        return this.endTime;
    }

    public long getElapsedTime() {
        if (this.endTime == null || this.startTime == null) {
            return 0L;
        }
        return this.endTime - this.startTime;
    }

    public long getDeltaTime() {
        if (this.currentTime == null || this.startTime == null) {
            return 0L;
        }
        return this.currentTime - this.startTime;
    }

    public TLEntity entityEntered(TLEntity entity) {
        this.setEndTime(Calendar.getInstance().getTimeInMillis());
        Logger.getLogger("TL").info(MessageFormat.format("Entity {0} has entered the map.", entity.toString()));
        if (this.agentsRecords.add(entity)) {
            entity.setColor(this.getColorManager().getNewColor());
            entity.addListener(new TLEntity.Adapter(){

                @Override
                public void endTimeChanged(TLEntity entity, long previousEndTime, long endTime) {
                    TLDatabase.this.setEndTime(endTime);
                }
            });
            this.emitEntityEntered(entity);
            return this.agentsRecords.getLast();
        }
        return null;
    }

    private void emitEntityEntered(TLEntity entity) {
        for (TLDatabaseListener listener : this.getListeners()) {
            listener.onEntityEntered(this, entity);
        }
    }

    protected void emitEntityLeft(TLEntity entity) {
        for (TLDatabaseListener listener : this.getListeners()) {
            listener.onEntityLeft(this, entity);
        }
    }

    private TLDatabaseListener[] getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        return this.listeners.toArray(new TLDatabaseListener[this.listeners.size()]);
    }

    public void addDBListener(TLDatabaseListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public void removeDBListener(TLDatabaseListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.remove(listener);
    }

    public List<TLEntity> getEntities() {
        return Collections.unmodifiableList(this.agentsRecords);
    }

    private void setEndTime(long newEnd) {
        assert (newEnd >= this.startTime);
        if (newEnd > this.endTime) {
            long previousEndTime = this.endTime;
            this.endTime = newEnd;
            for (TLDatabaseListener listener : this.getListeners()) {
                listener.endTimeChanged(previousEndTime, this.endTime);
            }
        }
    }

    public void startRecording() {
        long now = Calendar.getInstance().getTimeInMillis();
        this.startTime = now;
        this.currentTime = now;
        this.endTime = now;
    }

    public void stopRecording() {
        long now = Calendar.getInstance().getTimeInMillis();
        this.endTime = now;
        for (TLEntity entity : this.getEntities()) {
            entity.finish();
        }
    }

    public void setCurrentTime(long currentTime) {
        assert (this.startTime <= currentTime && this.endTime >= currentTime);
        long previousCurrentTime = this.currentTime;
        this.currentTime = currentTime;
        for (TLDatabaseListener listener : this.getListeners()) {
            listener.currentTimeChanged(previousCurrentTime, currentTime);
        }
    }

    public Set<TLEntity> getEntities(long time) {
        HashSet<TLEntity> entitiesPresent = new HashSet<TLEntity>();
        for (TLEntity entity : this.agentsRecords) {
            if (entity.getStartTime() > time) continue;
            if (entity.getEndTime() >= time) {
                entitiesPresent.add(entity);
                continue;
            }
            if (entity.getState() != TLEntity.State.RECORDING) continue;
            entitiesPresent.add(entity);
        }
        return Collections.unmodifiableSet(entitiesPresent);
    }

    private ColorManager getColorManager() {
        if (this.colorManager == null) {
            this.colorManager = new ColorManager();
        }
        return this.colorManager;
    }

    private Date milisToDate(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        return c.getTime();
    }

    public void printInfo(PrintStream stream) {
        stream.println("Info about db (entities: " + this.getEntities().size() + " ) [" + this.milisToDate(this.getStartTime()) + ", " + this.milisToDate(this.getEndTime()) + "]");
        for (TLEntity entity : this.getEntities()) {
            entity.printInfo(stream);
        }
    }

    public IUnrealMap getMap() {
        return this.map;
    }

    public void setMap(IUnrealMap map) {
        this.map = map;
        try {
            this.updateMap(map);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Unable to add info to the map: " + ex.getMessage());
        }
    }

    private void updateMap(IUnrealMap mapToUpdate) throws ParserConfigurationException, SAXException, IOException {
        File mapFile;
        String pogamutDirString = System.getProperty("user.home") + "/" + ".pogamut";
        File pogamutDir = new File(pogamutDirString);
        if (!pogamutDir.exists()) {
            pogamutDir.mkdir();
        }
        if (!(mapFile = new File(pogamutDirString + "/" + "maps.xml")).exists()) {
            return;
        }
        if (!mapFile.isFile()) {
            return;
        }
        File file = mapFile;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(file);
        NodeList maps = doc.getElementsByTagName("map");
        for (int i = 0; i < maps.getLength(); ++i) {
            Node map = maps.item(i);
            IUnrealMapInfo info = this.readMap(file, (Element)((Object)map.getChildNodes()));
            if (!mapToUpdate.getName().equals(info.getName())) continue;
            mapToUpdate.addInfo(info);
            return;
        }
    }

    private IUnrealMapInfo readMap(File file, Element element) throws SAXException, IOException {
        MapInfo info = new MapInfo();
        NodeList mapname = element.getElementsByTagName("mapname");
        if (mapname.getLength() != 1) {
            throw new SAXException("Not one mapname.");
        }
        String mapNameText = mapname.item(0).getTextContent();
        info.setName(mapNameText);
        NodeList imageList = element.getElementsByTagName("image");
        if (imageList.getLength() != 1) {
            throw new SAXException("Not one image.");
        }
        String imageUrl = imageList.item(0).getTextContent();
        info.setImage(file.getParent() + "/" + imageUrl);
        NodeList imagePosTag = element.getElementsByTagName("imagePos");
        if (imagePosTag.getLength() != 1) {
            throw new SAXException("Not one imagePos tag.");
        }
        NodeList imagePoints = ((Element)imagePosTag.item(0)).getElementsByTagName("point");
        if (imagePoints.getLength() != 3) {
            throw new SAXException("Not three points in imagePos tag.");
        }
        for (int i = 0; i < imagePoints.getLength(); ++i) {
            Location l = this.readPoint((Element)imagePoints.item(i));
            info.setImagePoint(i, l);
        }
        NodeList worldPosTag = element.getElementsByTagName("worldPos");
        if (worldPosTag.getLength() != 1) {
            throw new SAXException("Not three points in imagePos tag.");
        }
        NodeList worldPoints = ((Element)worldPosTag.item(0)).getElementsByTagName("point");
        if (worldPoints.getLength() != 3) {
            throw new SAXException("Not three points in worldPos");
        }
        for (int i = 0; i < worldPoints.getLength(); ++i) {
            Location l = this.readPoint((Element)worldPoints.item(i));
            info.setWorldPos(i, l);
        }
        return info;
    }

    private Location readPoint(Element item) {
        String x = item.getAttribute("x");
        String y = item.getAttribute("y");
        String z = item.getAttribute("z");
        return new Location(Double.valueOf(x).doubleValue(), Double.valueOf(y).doubleValue(), Double.valueOf(z).doubleValue());
    }

    public static interface TLDatabaseListener {
        public void startTimeChanged(long var1, long var3);

        public void currentTimeChanged(long var1, long var3);

        public void endTimeChanged(long var1, long var3);

        public void onEntityEntered(TLDatabase var1, TLEntity var2);

        public void onEntityLeft(TLDatabase var1, TLEntity var2);
    }

    public static class Adapter
    implements TLDatabaseListener {
        @Override
        public void startTimeChanged(long previousStartTime, long startTime) {
        }

        @Override
        public void currentTimeChanged(long previousCurrentTime, long currentTime) {
        }

        @Override
        public void endTimeChanged(long previousEndTime, long endTime) {
        }

        @Override
        public void onEntityEntered(TLDatabase db, TLEntity entity) {
        }

        @Override
        public void onEntityLeft(TLDatabase db, TLEntity entity) {
        }
    }
}

