/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.widgets;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class TimeTicsWidget
extends Widget {
    protected long totalTime = 0L;
    private static int majorTickHeight = 10;
    private Stroke lineStroke = new BasicStroke(3.0f);

    public TimeTicsWidget(Scene scene) {
        super(scene);
    }

    protected Rectangle calculateClientArea() {
        Graphics2D g = this.getGraphics();
        Rectangle2D r = g.getFontMetrics().getStringBounds("0", g);
        double height = (double)(majorTickHeight + 1) + r.getHeight();
        return new Rectangle(-80, -5, (int)(this.totalTime / 100L) + 1, (int)height);
    }

    protected void paintWidget() {
        int secondsPerTick = 10;
        int secTickHeight = 6;
        Graphics2D g = this.getGraphics();
        g.setColor(this.getForeground());
        int ticksNum = (int)(this.totalTime / (long)(1000 * secondsPerTick));
        Stroke formerStroke = g.getStroke();
        g.setStroke(this.lineStroke);
        g.drawLine(0, 0, (int)(this.totalTime / 100L), 0);
        for (int tick = 0; tick <= ticksNum; ++tick) {
            int x = tick * secondsPerTick * 1000 / 100;
            g.drawLine(x, 0, x, majorTickHeight);
            String time = tick * secondsPerTick / 60 + ":" + tick * secondsPerTick % 60;
            Rectangle2D r = g.getFontMetrics().getStringBounds(time, g);
            g.drawString(time, (float)x - (float)r.getWidth() * 0.5f, (float)majorTickHeight + (float)r.getHeight());
            int lastSecTick = (int)(this.totalTime / 1000L < (long)((tick + 1) * secondsPerTick - 1) ? this.totalTime / 1000L : (long)((tick + 1) * secondsPerTick - 1));
            for (int secTick = tick * secondsPerTick + 1; secTick <= lastSecTick; ++secTick) {
                int secX = secTick * 1000 / 100;
                g.drawLine(secX, 0, secX, secTickHeight);
            }
        }
        g.setStroke(formerStroke);
    }

    public void setTime(long newTime) {
        Logger.getLogger("TL").fine("Tick widget changed to " + newTime);
        this.totalTime = newTime;
        this.revalidate();
    }
}

