/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.Box;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class MapViewpoint {
    private Location center;
    private Location eye;
    private Vector3d up;
    private Set<ViewpointListener> listeners = new HashSet<ViewpointListener>();

    public MapViewpoint() {
        this(0.0, 0.0, 0.0);
    }

    public MapViewpoint(double x, double y, double z) {
        this.center = new Location(x, y, z);
        this.eye = new Location(0.0, 0.0, 0.0);
        this.up = new Vector3d(1.0, 0.0, 0.0);
    }

    public void moveEye(double deltaX, double deltaY, double deltaZ) {
        this.eye = new Location(this.eye.x + deltaX, this.eye.y + deltaY, this.eye.z + deltaZ);
        this.emitChangedViewport();
    }

    public Location getLocation() {
        return new Location(this.center);
    }

    public Location getEye() {
        return new Location(this.eye);
    }

    public Vector3d getUp() {
        return new Vector3d(this.up);
    }

    public Location getEye2Center() {
        return Location.sub((Location)this.center, (Location)this.eye);
    }

    public double getCenter2EyeDistance() {
        return Location.getDistance((Location)this.eye, (Location)this.center);
    }

    public Location getRightVector() {
        Location moveUpVec = new Location(this.up.x, this.up.y, this.up.z);
        Location center2eye = Location.sub((Location)this.getEye(), (Location)this.getLocation());
        Location moveRightVec = center2eye.cross(moveUpVec).getNormalized();
        return moveRightVec;
    }

    public void setLocation(double x, double y, double z) {
        this.center = new Location(x, y, z);
        this.emitChangedViewport();
    }

    public void setFromViewedBox(Box box) {
        this.center = new Location(box.getCenterX(), box.getCenterY(), box.getCenterZ());
        double max = Math.max(box.getDeltaX(), box.getDeltaY());
        this.eye = new Location(box.getCenterX(), box.getCenterY(), box.getCenterZ() - max);
        this.up.x = 0.0;
        this.up.y = 1.0;
        this.up.z = 0.0;
    }

    public void rotateEye(Location axis, double angle) {
        Location eyeVector = Location.sub((Location)this.eye, (Location)this.center);
        Location newEyeVector = MapViewpoint.rotateVectorAroundAxis(eyeVector, axis, angle);
        Location newUpVector = MapViewpoint.rotateVectorAroundAxis(new Location(this.up.x, this.up.y, this.up.z), axis, angle);
        this.eye = Location.add((Location)this.center, (Location)newEyeVector);
        this.up = new Vector3d(newUpVector.x, newUpVector.y, newUpVector.z);
        this.emitChangedViewport();
    }

    public void rotateCenter(Location axis, double angle) {
        Location eyeVector = Location.sub((Location)this.center, (Location)this.eye);
        Location newEye2Center = MapViewpoint.rotateVectorAroundAxis(eyeVector, axis, angle);
        Location newUpVector = MapViewpoint.rotateVectorAroundAxis(new Location(this.up.x, this.up.y, this.up.z), axis, angle);
        this.center = Location.add((Location)this.eye, (Location)newEye2Center);
        this.up = new Vector3d(newUpVector.x, newUpVector.y, newUpVector.z);
        this.emitChangedViewport();
    }

    public static Location rotateVectorAroundAxis(Location vector, Location axis, double angle) {
        double x = axis.x;
        double y = axis.y;
        double z = axis.z;
        double radianAngle = angle * Math.PI / 180.0;
        double c = Math.cos(radianAngle);
        double s = Math.sin(radianAngle);
        Matrix4d rotateMatrix = new Matrix4d(x * x * (1.0 - c) + c, x * y * (1.0 - c) - z * s, x * z * (1.0 - c) + y * s, 0.0, y * x * (1.0 - c) + z * s, y * y * (1.0 - c) + c, y * z * (1.0 - c) - x * s, 0.0, x * z * (1.0 - c) - y * s, y * z * (1.0 - c) + x * s, z * z * (1.0 - c) + c, 0.0, 0.0, 0.0, 0.0, 1.0);
        Vector3d vec = new Vector3d(vector.x, vector.y, vector.z);
        rotateMatrix.transform(vec);
        return new Location(vec.x, vec.y, vec.z);
    }

    public void setFrontView(Box box) {
        this.center = new Location(box.getCenterX(), box.getCenterY(), box.getCenterZ());
        double maxDelta = Math.max(box.getDeltaX(), box.getDeltaZ());
        double halfAngleRad = Math.PI * (this.getViewAngle() / 2.0 / 180.0);
        double distance = maxDelta / 2.0 / Math.tan(halfAngleRad);
        this.eye = new Location(box.getCenterX(), box.getCenterY() - box.getDeltaY() / 2.0 - distance, box.getCenterZ());
        this.up.x = 0.0;
        this.up.y = 0.0;
        this.up.z = 1.0;
        this.emitChangedViewport();
    }

    public void setSideView(Box box) {
        this.center = new Location(box.getCenterX(), box.getCenterY(), box.getCenterZ());
        double maxDelta = Math.max(box.getDeltaZ(), box.getDeltaY());
        double halfAngleRad = Math.PI * (this.getViewAngle() / 2.0 / 180.0);
        double distance = maxDelta / 2.0 / Math.tan(halfAngleRad);
        this.eye = new Location(box.getCenterX() + box.getDeltaX() / 2.0 + distance, box.getCenterY(), box.getCenterZ());
        this.up.x = 0.0;
        this.up.y = 0.0;
        this.up.z = 1.0;
        this.emitChangedViewport();
    }

    public void setTopView(Box box) {
        this.center = new Location(box.getCenterX(), box.getCenterY(), box.getCenterZ());
        double maxDelta = Math.max(box.getDeltaX(), box.getDeltaY());
        double halfAngleRad = Math.PI * (this.getViewAngle() / 2.0 / 180.0);
        double distance = maxDelta / 2.0 / Math.tan(halfAngleRad);
        this.eye = new Location(box.getCenterX(), box.getCenterY(), box.getCenterZ() + box.getDeltaZ() / 2.0 + distance);
        this.up.x = 0.0;
        this.up.y = 1.0;
        this.up.z = 0.0;
        this.emitChangedViewport();
    }

    public double getViewAngle() {
        return 45.0;
    }

    public void move(Location moveVec) {
        this.center = this.center.add(moveVec);
        this.eye = this.eye.add(moveVec);
        this.emitChangedViewport();
    }

    public void move(double deltaX, double deltaY, double deltaZ) {
        this.move(new Location(deltaX, deltaY, deltaZ));
    }

    void zoom(double factor, double minDist) {
        Location center2eye = Location.sub((Location)this.eye, (Location)this.center);
        this.eye = Location.add((Location)this.center, (Location)center2eye.scale(factor));
        this.emitChangedViewport();
    }

    private void emitChangedViewport() {
        ViewpointListener[] listenersArray;
        for (ViewpointListener listener : listenersArray = this.listeners.toArray(new ViewpointListener[0])) {
            listener.onChangedViewpoint(this);
        }
    }

    public void addViewpointListener(ViewpointListener listener) {
        this.listeners.add(listener);
    }

    public boolean isViewpointListener(ViewpointListener listener) {
        return this.listeners.contains(listener);
    }

    public void removeViewpointListener(ViewpointListener listener) {
        this.listeners.remove(listener);
    }

    public void lookAt(Location location, int axis, boolean upFlag) {
        System.out.println("Look at target: " + location);
        Vector3d newEye2Center = new Vector3d();
        newEye2Center.x = location.x - this.eye.x;
        newEye2Center.y = location.y - this.eye.y;
        newEye2Center.z = location.z - this.eye.z;
        Vector3d currentEye2Center = new Vector3d(this.getEye2Center().x, this.getEye2Center().y, this.getEye2Center().z);
        double angle = currentEye2Center.angle(newEye2Center);
        System.out.println("Angle " + angle + " " + angle * 180.0 / Math.PI);
    }

    public static interface ViewpointListener {
        public void onChangedViewpoint(MapViewpoint var1);
    }
}

