/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.server;

import cz.cuni.amis.nb.pogamut.base.NamedAction;
import cz.cuni.amis.nb.pogamut.unreal.timeline.UTTimelineNode;
import cz.cuni.amis.nb.pogamut.unreal.timeline.dataobject.TLDataObject;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.nb.util.collections.ObservableCollectionNode;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.exception.PogamutException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TimelinesNode
extends ObservableCollectionNode<TLDataObject> {
    private ObservableCollection<TLDataObject> experiments;
    private IUnrealServer server;
    protected static ResourceBundle bundle = NbBundle.getBundle(TimelinesNode.class);

    public TimelinesNode(IUnrealServer server) {
        this(server, (ObservableCollection<TLDataObject>)new ObservableCollection(new LinkedList()));
    }

    public TimelinesNode(final IUnrealServer server, ObservableCollection<TLDataObject> experiments) {
        super(experiments, (NodeFactory)new NodeFactory<TLDataObject>(){

            public Node[] create(TLDataObject obj) {
                return new Node[]{new UTTimelineNode(obj, server)};
            }
        });
        this.setName("Timelines");
        this.experiments = experiments;
        this.server = server;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"cz/cuni/amis/nb/pogamut/ut2004/timeline/dataobject/timeline_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new NamedAction("ACT_AddTimeline"){

            protected void action(ActionEvent e) throws PogamutException {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return true;
                    }

                    @Override
                    public String getDescription() {
                        return "Pogamut timeline (*.ptl)";
                    }
                });
                int res = fileChooser.showSaveDialog(null);
                if (res == -1) {
                    NotifyDescriptor.Message errorMessage = new NotifyDescriptor.Message((Object)bundle.getString("MSG_UnableToSaveTimeline"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)errorMessage);
                    return;
                }
                if (res == 0) {
                    try {
                        File file = fileChooser.getSelectedFile();
                        if (!file.getAbsolutePath().endsWith(".ptl")) {
                            file = new File(file.getAbsolutePath() + ".ptl");
                        }
                        if (file.exists()) {
                            NotifyDescriptor.Confirmation overwriteDialog = new NotifyDescriptor.Confirmation((Object)(bundle.getString("MSG_OverwriteFileStart") + file.getName() + bundle.getString("MSG_OverwriteFileEnd")), 2, 3);
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)overwriteDialog) != NotifyDescriptor.OK_OPTION) {
                                return;
                            }
                        }
                        FileObject fo = FileUtil.createData((File)file);
                        TLDataObject dataObject = (TLDataObject)DataObject.find((FileObject)fo);
                        dataObject.setSourceServer(TimelinesNode.this.server);
                        OpenCookie oc = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                        if (oc != null) {
                            oc.open();
                        }
                        TimelinesNode.this.experiments.add((Object)dataObject);
                    }
                    catch (IOException ex) {
                        NotifyDescriptor.Message errorMessage = new NotifyDescriptor.Message((Object)(bundle.getString("MSG_UnableToSaveTimeline") + "\n" + ex.getMessage()), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)errorMessage);
                        return;
                    }
                }
            }
        }};
    }
}

