/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import java.util.ArrayList;

public class TLRecord<T> {
    private long startTimestamp;
    private long endTimestamp;
    private TLVarInfo varInfo;
    private ArrayList<Record<T>> records;

    TLRecord(TLVarInfo info, long timestamp) {
        this.varInfo = info;
        this.startTimestamp = timestamp;
        this.endTimestamp = timestamp;
    }

    public TLVarInfo getInfo() {
        return this.varInfo;
    }

    protected synchronized ArrayList<Record<T>> getRecords() {
        if (this.records == null) {
            this.records = new ArrayList();
        }
        return this.records;
    }

    public synchronized Record addRecord(long timestamp, T value) {
        Record<T> record = null;
        if (this.getRecords().isEmpty()) {
            record = new Record<T>(timestamp, value);
            this.getRecords().add(record);
            this.startTimestamp = timestamp;
        } else {
            int size = this.getRecords().size();
            Record<T> tailRecord = this.getRecords().get(size - 1);
            if (tailRecord.timestamp > timestamp) {
                throw new RuntimeException("Invalid addition: Passed timestamp (" + timestamp + ") is younger than lastly added record (" + tailRecord.timestamp + ")");
            }
            if (value != tailRecord.value || tailRecord.value != null && !tailRecord.value.equals(value) || value != null && !value.equals(tailRecord.value)) {
                record = new Record<T>(timestamp, value);
                this.getRecords().add(record);
            }
        }
        this.endTimestamp = timestamp;
        return record;
    }

    public class Record<T> {
        long timestamp;
        T value;

        Record(long timestamp, T value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }

    class TLVarInfo {
        TLVarInfo() {
        }
    }
}

