/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;
import org.openide.util.Exceptions;

public class GLTools {
    private static GLU glu = new GLU();
    private static GLUT glut = new GLUT();
    private static Texture texture;

    public static Location getWorldCoordinates(GL gl, GLU glu, Location screen, Location store) {
        if (store == null) {
            store = new Location(0.0, 0.0, 0.0);
        }
        DoubleBuffer mvBuffer = DoubleBuffer.allocate(16);
        gl.glGetDoublev(2982, mvBuffer);
        DoubleBuffer prBuffer = DoubleBuffer.allocate(16);
        gl.glGetDoublev(2983, prBuffer);
        IntBuffer vpBuffer = IntBuffer.allocate(16);
        gl.glGetIntegerv(2978, vpBuffer);
        DoubleBuffer result = DoubleBuffer.allocate(3);
        glu.gluUnProject(screen.x, screen.y, screen.z, mvBuffer, prBuffer, vpBuffer, result);
        store = new Location(result.get(0), result.get(1), result.get(2));
        return store;
    }

    public static Location getScreenCoordinates(GL gl, GLU glu, Location worldPosition, Location store) {
        if (store == null) {
            store = new Location(0.0, 0.0, 0.0);
        }
        DoubleBuffer mvBuffer = DoubleBuffer.allocate(16);
        gl.glGetDoublev(2982, mvBuffer);
        DoubleBuffer prBuffer = DoubleBuffer.allocate(16);
        gl.glGetDoublev(2983, prBuffer);
        IntBuffer vpBuffer = IntBuffer.allocate(16);
        gl.glGetIntegerv(2978, vpBuffer);
        DoubleBuffer result = DoubleBuffer.allocate(3);
        glu.gluProject(worldPosition.x, worldPosition.y, worldPosition.z, mvBuffer, prBuffer, vpBuffer, result);
        store = new Location(result.get(0), result.get(1), result.get(2));
        return store;
    }

    public static void renderWindow(GL gl, int x, int y, int width, int height) {
        GLTools.pushMatrixMode(gl);
        GLTools.setOrthoViewport(gl);
        try {
            double z = 0.0;
            if (texture == null) {
                texture = TextureIO.newTexture((File)new File("c:/temp/windowTexture.PNG"), (boolean)false);
            }
            texture.bind();
            texture.enable();
            gl.glBegin(7);
            gl.glColor3d(1.0, 1.0, 1.0);
            gl.glTexCoord2d(0.0, 0.0);
            gl.glVertex3d((double)x, (double)y, z);
            gl.glTexCoord2d(1.0, 0.0);
            gl.glVertex3d((double)(x + width), (double)y, z);
            gl.glTexCoord2d(1.0, 1.0);
            gl.glVertex3d((double)(x + width), (double)(y + height), z);
            gl.glTexCoord2d(0.0, 1.0);
            gl.glVertex3d((double)x, (double)(y + height), z);
            gl.glEnd();
            texture.disable();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (GLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        GLTools.popMatrixMode(gl);
    }

    public static void setOrthoViewport(GL gl) {
        Rectangle viewport = GLTools.getViewport(gl);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(viewport.getMinX(), viewport.getMaxX(), viewport.getMinY(), viewport.getMaxY(), -1.0, 1.0);
        gl.glMatrixMode(5888);
    }

    public static Rectangle getViewport(GL gl) {
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        return new Rectangle(viewport[0], viewport[1], viewport[2], viewport[3]);
    }

    public static void pushMatrixMode(GL gl) {
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
    }

    public static void popMatrixMode(GL gl) {
        gl.glMatrixMode(5889);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }
}

