/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.map;

import com.sun.opengl.util.GLUT;
import cz.cuni.amis.nb.pogamut.unreal.map.BlendTriangle;
import cz.cuni.amis.nb.pogamut.unreal.services.IPogamutEnvironments;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.GLTools;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.GlColor;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IFadeLine;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IRenderableUTAgent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.ISubGLRenderer;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.MapEvent;
import cz.cuni.amis.pogamut.base.utils.logging.marks.LogMapMark;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import org.openide.util.Lookup;

public class UTAgentSubGLRenderer
implements ISubGLRenderer<IRenderableUTAgent> {
    private static Logger logger;
    private static GLU glu;
    private static GLUT glut;
    private static GLUquadric quadratic;
    private final IRenderableUTAgent agent;
    private final IUnrealMap map;
    private static final double SPHERE_RADIUS = 60.0;
    private static final int SPHERE_SLICES = 32;
    private static final int SPHERE_STACKS = 32;

    public UTAgentSubGLRenderer(IRenderableUTAgent utAgent, IUnrealMap map) {
        this.agent = utAgent;
        this.map = map;
    }

    @Override
    public void prepare(GL gl) {
    }

    @Override
    public IRenderableUTAgent getObject() {
        return this.agent;
    }

    @Override
    public void render(GL gl) {
        try {
            Location entityLocation = this.agent.getLocation();
            if (entityLocation == null) {
                return;
            }
            Location center = new Location(entityLocation.x, entityLocation.y, entityLocation.z + 66.0);
            GlColor color = new GlColor(this.agent.getColor());
            gl.glLoadName(this.agent.getGLName());
            this.renderAgent(gl, color, center);
            gl.glLoadName(-1);
            this.renderInfo(gl, color, center);
            this.renderFade(gl, color, this.agent.getFadeLine());
            for (MapEvent mapEvent : this.agent.getMapEvents()) {
                if (mapEvent.shouldFollowPlayer()) continue;
                this.renderPlacedMapEvent(gl, color, mapEvent);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void renderAgent(GL gl, GlColor color, Location position) {
        gl.glPushMatrix();
        gl.glTranslated(position.x, position.y, position.z);
        gl.glColor4d(color.r, color.g, color.b, color.a);
        glu.gluSphere(quadratic, 60.0, 32, 32);
        IPogamutEnvironments environments = (IPogamutEnvironments)Lookup.getDefault().lookup(IPogamutEnvironments.class);
        if (environments != null) {
            Collection c = environments.getEnvironmentSelection(this.map).lookupAll(this.agent.getDataSource().getClass());
            for (Object o : c) {
                if (!this.agent.getDataSource().equals(o)) continue;
                gl.glColor3d(0.3, 0.3, 0.3);
                glu.gluDisk(quadratic, 72.0, 90.0, 32, 3);
            }
        }
        gl.glPopMatrix();
        Rotation rot = this.agent.getRotation();
        if (rot != null) {
            this.renderRotation(gl, new GlColor(1.0, 0.0, 0.0), position, rot);
        }
    }

    private void renderRotation(GL gl, GlColor color, Location center, Rotation rotation) {
        gl.glPushMatrix();
        gl.glTranslated(center.x, center.y, center.z);
        Location endOfArrow = rotation.toLocation().getNormalized().scale(150.0);
        gl.glBegin(1);
        gl.glColor4d(color.r, color.g, color.b, color.a);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(endOfArrow.x, endOfArrow.y, endOfArrow.z);
        gl.glEnd();
        gl.glTranslated(endOfArrow.x, endOfArrow.y, endOfArrow.z);
        double yaw = rotation.getYaw() / 32767.0 * 180.0;
        double roll = rotation.getRoll() / 32767.0 * 180.0;
        double pitch = rotation.getPitch() / 32767.0 * 180.0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Rotation: Yaw " + yaw + " roll " + roll + " pitch " + pitch);
        }
        gl.glRotated(yaw, 0.0, 0.0, 1.0);
        gl.glRotated(90.0, 0.0, 1.0, 0.0);
        glut.glutSolidCone(20.0, 40.0, 16, 16);
        gl.glPopMatrix();
    }

    private void renderFade(GL gl, GlColor color, IFadeLine fadeline) {
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glBegin(7);
        Location lastLocation = null;
        double lastAlpha = 0.0;
        for (long ms = 0L; ms < fadeline.getDuration(); ms += 100L) {
            Location currentLocation = fadeline.getPosition(ms);
            double currentAlpha = (double)ms / (double)fadeline.getDuration();
            if (lastLocation == null) {
                lastLocation = currentLocation;
                lastAlpha = currentAlpha;
                continue;
            }
            if (currentLocation == null) continue;
            this.pushFadeQuad(gl, color, currentLocation, lastLocation, currentAlpha, lastAlpha);
            lastLocation = currentLocation;
            lastAlpha = currentAlpha;
        }
        gl.glEnd();
        gl.glDisable(3042);
    }

    private void pushFadeQuad(GL gl, GlColor color, Location start, Location end, double startAlpha, double endAlpha) {
        Location dir = Location.sub((Location)start, (Location)end).setZ(0.0);
        if (dir.getLength() == 0.0) {
            return;
        }
        dir = dir.getNormalized();
        Location trans = new Location(dir.y, -dir.x, 0.0);
        trans = trans.scale(6.0);
        Location p1 = end.sub(trans);
        Location p2 = end.add(trans);
        gl.glColor4d(color.r, color.g, color.b, 1.0 - endAlpha);
        gl.glVertex3d(p1.x, p1.y, p1.z + 60.0);
        gl.glVertex3d(p2.x, p2.y, p2.z + 60.0);
        Location p3 = start.add(trans);
        Location p4 = start.sub(trans);
        gl.glColor4d(color.r, color.g, color.b, 1.0 - startAlpha);
        gl.glVertex3d(p3.x, p3.y, p3.z + 60.0);
        gl.glVertex3d(p4.x, p4.y, p4.z + 60.0);
    }

    private void renderInfo(GL gl, GlColor color, Location location) {
        ArrayList<String> infos = new ArrayList<String>(this.agent.getAssociatedInfo());
        infos.add(0, '*' + this.agent.getName() + '*');
        Location topHead = new Location(location);
        topHead = new Location(topHead.x, topHead.y, topHead.z + 132.0);
        Location top2d = GLTools.getScreenCoordinates(gl, glu, topHead, null);
        int lineGap = 12;
        int font = 6;
        int maxWidth = 0;
        for (String line : infos) {
            int lineWidth = glut.glutBitmapLength(font, line);
            if (lineWidth <= maxWidth) continue;
            maxWidth = lineWidth;
        }
        top2d = new Location(top2d.x - (double)(maxWidth / 2), top2d.y + (double)((infos.size() - 1) * lineGap));
        GlColor textColor = color.getMixedWith(new GlColor(0.0, 0.0, 0.0), 80.0);
        gl.glColor3d(textColor.r, textColor.g, textColor.b);
        for (int i = 0; i < infos.size(); ++i) {
            String text = (String)infos.get(i);
            if (i == 0) {
                gl.glColor3d(color.r, color.g, color.b);
            } else {
                gl.glColor3d(textColor.r, textColor.g, textColor.b);
            }
            Location textPos = GLTools.getWorldCoordinates(gl, glu, top2d, null);
            gl.glRasterPos3d(textPos.x, textPos.y, textPos.z);
            glut.glutBitmapString(font, text);
            top2d = top2d.setY(top2d.y - (double)lineGap);
        }
    }

    private void renderPlacedMapEvent(GL gl, GlColor color, MapEvent mapEvent) {
        LogMapMark mapMark = mapEvent.getMark();
        Location position = mapMark.getLocation();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" MSG: " + mapMark.getMessage() + ", LOC: " + position);
        }
        gl.glPushMatrix();
        gl.glTranslated(position.x, position.y, position.z + 66.0);
        gl.glColor4d(color.r, color.g, color.b, color.a);
        glu.gluCylinder(quadratic, 60.0, 60.0, 120.0, 4, 1);
        gl.glPopMatrix();
        gl.glDisable(2929);
        gl.glColor3d(0.0, 0.0, 0.0);
        gl.glRasterPos3d(position.x, position.y, position.z);
        glut.glutBitmapString(7, mapEvent.getMessage());
        gl.glColor3d(1.0, 1.0, 1.0);
        gl.glEnable(2929);
    }

    @Override
    public List<BlendTriangle> getBlendedTris() {
        return new LinkedList<BlendTriangle>();
    }

    static {
        glu = new GLU();
        glut = new GLUT();
        quadratic = glu.gluNewQuadric();
        logger = Logger.getLogger("TLMapRenderer");
        logger.setLevel(Level.INFO);
    }
}

