package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.openide.nodes.Children;

/**
 * List of all APs in POSH plan. Dynamically actualized.
 *
 * During creation of PoshTreeDataObject it looks up the children of categories
 * (including this one) and adds it as listener for root
 *
 * @author Honza
 */
public class APsChildren extends Children.SortedMap<ActionPattern> implements PoshElementListener {

    @Override
    public void nodeChanged(PoshTreeEvent event, PoshElement child) {
        refresh(child.getRootNode());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        refresh(((PoshElement)evt.getSource()).getRootNode());
    }

    public void refresh(PoshPlan plan) {
        List<ActionPattern> aps = plan.getActionPatterns();

        // remove all old actions in palette
        for (ActionPattern ap : this.nodes.keySet().toArray(new ActionPattern[0])) {
            remove(ap);
        }
        
        for (ActionPattern ap : aps) {
            this.put(ap, new APNode(ap));
        }
        this.refresh();
    }


}
