package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.nodes.Children;
import org.openide.util.datatransfer.ExTransferable;

/**
 * Node that represent Add AP in the palette.
 * @author Honza
 */
class AddAPActionNode extends PoshPaletteNode {

//	public final static DataFlavor dataFlavor = new DataFlavor(AddAPActionNode.class, "add-AP");
	static int num = 10;

	AddAPActionNode() {
		super(Children.LEAF);

		this.setName("(AP ap (doNothing))");
		this.setDisplayName("AP");
	}

	/**
	 * Ask user for name of new action pattern, create the AP and return it
	 * encapsulated in ExTransferable.
	 *
	 * @return ExTransferable that contains created AP.
	 */
	@Override
	protected ExTransferable.Single createTransferable() {
		return new ExTransferable.Single(ActionPattern.dataFlavor) {

			@Override
			protected Object getData() throws IOException, UnsupportedFlavorException {
				String id = PGSupport.getIdentifierFromDialog("Name of new AP");
				if (id == null) {
					return null;
				}

				ActionPattern ap = new ActionPattern(id);

				return ap;
			}
		};
	}

}
