package cz.cuni.pogamut.posh.palette;

import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.nodes.Children;
import org.openide.util.datatransfer.ExTransferable;

/**
 * Representation of "Add action" in palette.
 * @author Honza
 */
class AddTAActionNode extends PoshPaletteNode {
//	public final static DataFlavor dataFlavor = new DataFlavor(AddTAActionNode.class, "add-triggered-action");

	AddTAActionNode() {
		super(Children.LEAF);

		this.setName("doNothing");
		this.setDisplayName("Action");
	}

	@Override
	protected ExTransferable.Single createTransferable() {
		return new ExTransferable.Single(TriggeredAction.dataFlavor) {

			@Override
			protected Object getData() throws IOException, UnsupportedFlavorException {
				String id = PGSupport.getIdentifierFromDialog("Name of new action");
				if (id == null) {
					return null;
				}

				return new TriggeredAction(id);
			}
		};
	}
}

