/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.muse.utils.amuse;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kul.cs.liir.muse.amuse.jaxb.DependencyRelation;
import kul.cs.liir.muse.amuse.jaxb.Entity;
import kul.cs.liir.muse.amuse.jaxb.EntityMention;
import kul.cs.liir.muse.amuse.jaxb.Frame;
import kul.cs.liir.muse.amuse.jaxb.ISentenceElement;
import kul.cs.liir.muse.amuse.jaxb.PartOfSpeech;
import kul.cs.liir.muse.amuse.jaxb.Role;
import kul.cs.liir.muse.amuse.jaxb.Sentence;
import kul.cs.liir.muse.amuse.jaxb.Text;
import kul.cs.liir.muse.amuse.jaxb.Token;
import kul.cs.liir.muse.semlink.PropBankVerbNet;
import kul.cs.liir.muse.semlink.pbverbnet.ArgMap;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;

public class AmuseConverter {
    Map<Word, Token> tokensFromWords = new HashMap<Word, Token>();
    Map<EntityMention, Entity> entityFromEntityMention = new HashMap<EntityMention, Entity>();
    Map<String, Entity> entityByLemma = new HashMap<String, Entity>();
    Map<Integer, SentenceData> sentenceDataMap = new HashMap<Integer, SentenceData>();
    Map<CorefChain.CorefMention, Entity> representativeEntitiesMap = new HashMap<CorefChain.CorefMention, Entity>();
    PropBankVerbNet propBankVerbNet;
    private final Logger logger = Logger.getLogger(AmuseConverter.class.getName());

    public AmuseConverter(PropBankVerbNet propBankVerbNet) {
        this.propBankVerbNet = propBankVerbNet;
    }

    protected String getTokenId(String sentenceId, int tokenIdx) {
        return String.valueOf(sentenceId) + "_Tk" + tokenIdx;
    }

    public Token jaxbTokenFromWord(Word w, String sentenceId) {
        if (this.tokensFromWords.containsKey(w)) {
            return this.tokensFromWords.get(w);
        }
        Token t = new Token(this.getTokenId(sentenceId, w.getIdx()));
        this.tokensFromWords.put(w, t);
        t.setConllForm(w.getForm());
        t.setConllPlemma(w.getLemma());
        t.setPartOfSpeech(PartOfSpeech.byXMLValue((String)w.getPOS()));
        t.setDepRelation(DependencyRelation.byXMLValue((String)w.getDeprel()));
        if (w.getHead() == null) {
            t.setHead(null);
        } else if (this.tokensFromWords.containsKey(w.getHead())) {
            t.setHead(this.tokensFromWords.get(w.getHead()));
        } else {
            Token headToken = this.jaxbTokenFromWord(w.getHead(), sentenceId);
            t.setHead(headToken);
        }
        return t;
    }

    protected String normalizeMentionString(String s) {
        return s.trim().toLowerCase().replaceAll("\\W", "");
    }

    public Frame frameFromPredicate(Predicate p, String frameId, SentenceData sData, Sentence target) {
        Frame f = new Frame();
        f.setId(frameId);
        f.setName(p.getSense());
        List verbNetArgMaps = this.propBankVerbNet.getArgMapsForPropBankFrameSet(p.getSense());
        ArgMap verbNetMap = null;
        if (verbNetArgMaps != null && !verbNetArgMaps.isEmpty()) {
            verbNetArgMaps.size();
            verbNetMap = (ArgMap)verbNetArgMaps.get(0);
            f.setVerbnetClass(verbNetMap.getVerbNetClass());
        }
        f.setRoot(this.tokensFromWords.get(p));
        for (Word w : p.getArgMap().keySet()) {
            String translatedRole;
            String propBankRole = (String)p.getArgMap().get(w);
            ArrayList<Integer> yieldIndices = new ArrayList<Integer>();
            Yield y = w.getYield(p, propBankRole, p.getArgMap().keySet());
            StringBuilder yieldBuilder = new StringBuilder();
            for (Word yieldWord : y) {
                yieldBuilder.append(yieldWord.getForm()).append(" ");
                yieldIndices.add(yieldWord.getIdx());
            }
            Role r = new Role();
            r.setEntityMention(this.getEntityMentionFromWord(w, y, sData, target));
            r.setPropBankRole(propBankRole);
            r.setYield(yieldBuilder.toString());
            if (verbNetMap != null && (translatedRole = verbNetMap.getVerbNetRole(propBankRole.replace("A", ""))) != null) {
                r.setVerbnetRole(translatedRole);
            }
            if (r.getEntityMention() != null) {
                r.corefText = r.getEntityMention().corefText;
            }
            r.setHeadToken(this.tokensFromWords.get(w));
            f.addRole(r);
        }
        return f;
    }

    protected EntityMention getEntityMentionFromWord(Word w, Yield yield, SentenceData sData, Sentence target) {
        Token t = this.tokensFromWords.get(w);
        if (t == null) {
            return null;
        }
        if (sData == null) {
            return null;
        }
        EntityMention bestMention = null;
        int bestMentionRank = 0;
        for (EntityMention candidateMention : sData.parsedEntityMentions) {
            boolean overlap = false;
            boolean allYieldInsideCandidate = true;
            for (Word yieldWord : yield) {
                boolean yieldInsideCandidate;
                boolean bl = yieldInsideCandidate = candidateMention.getStartTokenIndex() <= yieldWord.getIdx() && candidateMention.getEndTokenIndex() > yieldWord.getIdx();
                if (yieldInsideCandidate) {
                    overlap = true;
                    continue;
                }
                allYieldInsideCandidate = false;
            }
            boolean allCandidateInsideYield = true;
            int candidateIndex = candidateMention.getStartTokenIndex();
            while (candidateIndex < candidateMention.getEndTokenIndex()) {
                boolean candidateInsideYield = false;
                for (Word yieldWord : yield) {
                    if (yieldWord.getIdx() != candidateIndex) continue;
                    candidateInsideYield = true;
                    break;
                }
                if (!candidateInsideYield) {
                    allCandidateInsideYield = false;
                    break;
                }
                ++candidateIndex;
            }
            int candidateRank = allYieldInsideCandidate && allCandidateInsideYield ? 80 : (allCandidateInsideYield ? 40 : (allYieldInsideCandidate ? 30 : (overlap ? 10 : 0)));
            if (candidateMention.getComponents().contains(t)) {
                candidateRank += 5;
            }
            if (candidateRank <= bestMentionRank) continue;
            bestMention = candidateMention;
            bestMentionRank = candidateRank;
        }
        if (bestMention == null && PartOfSpeech.isNoun((PartOfSpeech)t.getPartOfSpeech())) {
            Entity ent = this.entityByLemma.get(t.getConllPlemma());
            if (ent == null) {
                ent = new Entity();
                ent.setConllPlemma(t.getConllPlemma());
                ent.setRepresentativeText(t.getConllPlemma());
                ent.setId(String.valueOf(target.getId()) + "_AddedEnt_" + t.getId());
                target.addElement((ISentenceElement)ent);
            }
            EntityMention mention = new EntityMention();
            mention.setEntity(ent);
            mention.setHeadToken(t);
            mention.setStartTokenIndex(w.getIdx());
            mention.setEndTokenIndex(w.getIdx() + 1);
            mention.setId(String.valueOf(target.getId()) + "_AddedMent_" + t.getId());
            target.addElement((ISentenceElement)mention);
            bestMention = mention;
        }
        return bestMention;
    }

    public Sentence jaxbSentenceFromSentence(se.lth.cs.srl.corpus.Sentence s, String sentenceId, int sentenceIndex, CoreMap corefSentence) {
        Sentence result = new Sentence(sentenceId);
        result.setOriginalText((String)corefSentence.get(CoreAnnotations.TextAnnotation.class));
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Word w : s) {
            Token token = this.jaxbTokenFromWord(w, sentenceId);
            tokens.add(token);
            result.addElement((ISentenceElement)token);
        }
        SentenceData sData = this.sentenceDataMap.get(sentenceIndex);
        if (sData != null) {
            int entIndex = 0;
            while (entIndex < sData.entitiesFromCoref.size()) {
                Entity ent = sData.entitiesFromCoref.get(entIndex);
                ent.setId(String.valueOf(sentenceId) + "_Ent" + entIndex);
                result.addElement((ISentenceElement)ent);
                ++entIndex;
            }
            int mentionIndex = 0;
            while (mentionIndex < sData.entityMentionsFromCoref.size()) {
                CorefChain.CorefMention corefMention = sData.entityMentionsFromCoref.get(mentionIndex);
                EntityMention mention = new EntityMention();
                mention.setId(String.valueOf(sentenceId) + "_Ment" + mentionIndex);
                mention.setEntity(this.representativeEntitiesMap.get(corefMention));
                mention.setHeadToken((Token)tokens.get(corefMention.headIndex));
                mention.setStartTokenIndex(corefMention.startIndex);
                mention.setEndTokenIndex(corefMention.endIndex);
                List corefTokens = (List)corefSentence.get(CoreAnnotations.TokensAnnotation.class);
                mention.corefText = "";
                int tokenIndex = corefMention.startIndex;
                while (tokenIndex < corefMention.endIndex) {
                    Token token = (Token)tokens.get(tokenIndex);
                    mention.addComponent(token);
                    mention.corefText = String.valueOf(mention.corefText) + ((CoreLabel)corefTokens.get(tokenIndex - 1)).originalText() + " ";
                    ++tokenIndex;
                }
                sData.parsedEntityMentions.add(mention);
                result.addElement((ISentenceElement)mention);
                ++mentionIndex;
            }
        }
        int frameId = 0;
        for (Predicate p : s.getPredicates()) {
            result.addElement((ISentenceElement)this.frameFromPredicate(p, String.valueOf(sentenceId) + "_Fr" + frameId, sData, result));
            ++frameId;
        }
        return result;
    }

    protected Entity entityFromRepresentativeMention(Annotation openNlpDocument, CorefChain.CorefMention representative) {
        CoreMap sentence = (CoreMap)((List)openNlpDocument.get(CoreAnnotations.SentencesAnnotation.class)).get(representative.sentNum - 1);
        List openNlpTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        CoreLabel headToken = (CoreLabel)openNlpTokens.get(representative.headIndex - 1);
        Entity ent = new Entity();
        ent.setConllPlemma(headToken.lemma());
        this.entityByLemma.put(headToken.lemma(), ent);
        StringBuilder corefTextBuilder = new StringBuilder();
        int i = representative.startIndex;
        while (i < representative.endIndex) {
            if (corefTextBuilder.length() > 0) {
                corefTextBuilder.append(" ");
            }
            corefTextBuilder.append(((CoreLabel)openNlpTokens.get(i - 1)).value());
            ++i;
        }
        ent.setRepresentativeText(corefTextBuilder.toString());
        return ent;
    }

    protected void analyzeOpenNlpCoref(Annotation openNlpDocument) {
        Map graph = (Map)openNlpDocument.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        for (CorefChain chain : graph.values()) {
            CorefChain.CorefMention representative = chain.getRepresentativeMention();
            Entity theEntity = this.entityFromRepresentativeMention(openNlpDocument, representative);
            int firstSentenceIndex = ((CorefChain.CorefMention)chain.getMentionsInTextualOrder().get((int)0)).sentNum - 1;
            SentenceData sData = this.sentenceDataMap.get(firstSentenceIndex);
            if (sData == null) {
                sData = new SentenceData();
                this.sentenceDataMap.put(firstSentenceIndex, sData);
            }
            sData.entitiesFromCoref.add(theEntity);
            for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                SentenceData sData2 = this.sentenceDataMap.get(mention.sentNum - 1);
                if (sData2 == null) {
                    sData2 = new SentenceData();
                    this.sentenceDataMap.put(mention.sentNum - 1, sData2);
                }
                sData2.entityMentionsFromCoref.add(mention);
                this.representativeEntitiesMap.put(mention, theEntity);
            }
        }
    }

    public Text textFromSentences(List<se.lth.cs.srl.corpus.Sentence> sentences, Annotation openNlpDocument, String id) {
        Text text = new Text(id);
        this.analyzeOpenNlpCoref(openNlpDocument);
        List corefSentences = (List)openNlpDocument.get(CoreAnnotations.SentencesAnnotation.class);
        int sentenceID = 1;
        int sentenceIndex = 0;
        while (sentenceIndex < sentences.size()) {
            se.lth.cs.srl.corpus.Sentence s = sentences.get(sentenceIndex);
            text.addSentence(this.jaxbSentenceFromSentence(s, String.valueOf(id) + "_S" + sentenceID, sentenceIndex, (CoreMap)corefSentences.get(sentenceIndex)));
            ++sentenceID;
            ++sentenceIndex;
        }
        return text;
    }

    private class SentenceData {
        List<Entity> entitiesFromCoref = new ArrayList<Entity>();
        List<CorefChain.CorefMention> entityMentionsFromCoref = new ArrayList<CorefChain.CorefMention>();
        List<EntityMention> parsedEntityMentions = new ArrayList<EntityMention>();

        private SentenceData() {
        }
    }
}

