/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.muse.webapp;

import com.google.inject.Inject;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import kul.cs.liir.muse.utils.IAmusePipelineProvider;

@Path(value="/opennlp")
public class OpenNLPService {
    private IAmusePipelineProvider pipelineProvider;

    @Inject
    public OpenNLPService(IAmusePipelineProvider pipelineProvider) {
        this.pipelineProvider = pipelineProvider;
    }

    @POST
    @Path(value="/coref")
    @Produces(value={"application/xml"})
    public String coref(@FormParam(value="text") String text) {
        StanfordCoreNLP coreNlp = this.pipelineProvider.getStanfordCoreNlp();
        Annotation ann = coreNlp.process(text);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            coreNlp.xmlPrint(ann, (OutputStream)os);
        }
        catch (IOException ex) {
            return "Error " + ex;
        }
        return new String(os.toByteArray());
    }
}

