/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.muse.webapp;

import com.google.inject.Inject;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import kul.cs.liir.muse.amuse.jaxb.Text;
import kul.cs.liir.muse.semlink.PropBankVerbNet;
import kul.cs.liir.muse.utils.IAmusePipelineProvider;
import kul.cs.liir.muse.utils.MUSEUtils;
import kul.cs.liir.muse.utils.amuse.AmuseConverter;
import kul.cs.liir.muse.webapp.ProcessingException;
import se.lth.cs.srl.SemanticRoleLabeler;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.preprocessor.Preprocessor;

@Path(value="/srl")
public class SRLService {
    private IAmusePipelineProvider pipelineProvider;
    private PropBankVerbNet propBankVerbNet;

    @Inject
    public SRLService(IAmusePipelineProvider pipelineStorage, PropBankVerbNet propBankVerbNet) {
        this.pipelineProvider = pipelineStorage;
        this.propBankVerbNet = propBankVerbNet;
    }

    private List<Sentence> parseToSentences(List<String> tokenizedText) {
        try {
            Preprocessor pp = this.pipelineProvider.getPreprocessor();
            SemanticRoleLabeler srl = this.pipelineProvider.getSrl();
            List sentences = MUSEUtils.parseTokenizedText(tokenizedText, (Preprocessor)pp, (SemanticRoleLabeler)srl);
            return sentences;
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    @POST
    @Path(value="/conll2008")
    @Produces(value={"text/plain"})
    public String parseTextToConll2008(@FormParam(value="text") String text) {
        StanfordCoreNLP coreNlp = this.pipelineProvider.getStanfordCoreNlpTokenizeOnly();
        Annotation openNlpDocument = coreNlp.process(text);
        List tokenizedText = MUSEUtils.stanfordNlpTokenizeText((Annotation)openNlpDocument);
        List<Sentence> sentences = this.parseToSentences(tokenizedText);
        StringBuilder responseBuilder = new StringBuilder();
        for (Sentence s : sentences) {
            responseBuilder.append(MUSEUtils.sentenceToStringConLL2008((Sentence)s)).append("\n\n");
        }
        return responseBuilder.toString();
    }

    @POST
    @Path(value="/conll")
    @Produces(value={"text/plain"})
    public String parseTextToConll(@FormParam(value="text") String text) {
        StanfordCoreNLP coreNlp = this.pipelineProvider.getStanfordCoreNlpTokenizeOnly();
        Annotation openNlpDocument = coreNlp.process(text);
        List tokenizedText = MUSEUtils.stanfordNlpTokenizeText((Annotation)openNlpDocument);
        List<Sentence> sentences = this.parseToSentences(tokenizedText);
        StringBuilder responseBuilder = new StringBuilder();
        for (Sentence s : sentences) {
            responseBuilder.append(s.toString()).append("\n\n");
        }
        return responseBuilder.toString();
    }

    @POST
    @Path(value="/amuse-xml")
    @Produces(value={"application/xml"})
    public Text parseTextToAmuse(@FormParam(value="text") String text, @FormParam(value="textId") String textId) {
        if (textId == null) {
            textId = "";
        }
        text = MUSEUtils.convertUnicodeCharacters((String)text);
        StanfordCoreNLP coreNlp = this.pipelineProvider.getStanfordCoreNlp();
        Annotation openNlpDocument = coreNlp.process(text);
        List tokenizedText = MUSEUtils.stanfordNlpTokenizeText((Annotation)openNlpDocument);
        List<Sentence> museSentences = this.parseToSentences(tokenizedText);
        AmuseConverter c = new AmuseConverter(this.propBankVerbNet);
        Text processedText = c.textFromSentences(museSentences, openNlpDocument, textId);
        return processedText;
    }
}

