/*
 * Decompiled with CFR 0.152.
 */
package kul.cs.liir.muse.webapp;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gba.spritely.Spritely;

@Path(value="/spritely")
public class SpritelyService {
    @GET
    @Path(value="/image/{objectName}")
    @Produces(value={"image/png"})
    public Response getSpritelyImage(@PathParam(value="objectName") String objectName) {
        Spritely s = new Spritely();
        s.setQuery(objectName);
        s.setSize(50);
        s.setImagesPerSource(1);
        s.setSearchGoogleImages(false);
        s.setSearchOpenClipart(true);
        s.setSearchWikimediaCommons(true);
        List spritelyResults = s.search();
        if (spritelyResults.isEmpty()) {
            return Response.noContent().build();
        }
        BufferedImage image = (BufferedImage)spritelyResults.get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
            byte[] imageData = baos.toByteArray();
            return Response.ok((Object)imageData).build();
        }
        catch (IOException ex) {
            return Response.serverError().build();
        }
    }
}

